/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtDeclarationTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

public class KtFileTreeNode
extends PsiFileNode {
    public KtFileTreeNode(Project project, KtFile value2, ViewSettings viewSettings) {
        super(project, (PsiFile)value2, viewSettings);
    }

    public final KtFile getKtFile() {
        return (KtFile)this.getValue();
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        KtFile file2 = (KtFile)this.getValue();
        if (file2 == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        if (this.getSettings().isShowMembers()) {
            List<KtDeclaration> declarations2 = file2.getDeclarations();
            for (KtDeclaration declaration2 : declarations2) {
                if (declaration2 instanceof KtClassOrObject) {
                    result2.add((AbstractTreeNode)new KtClassOrObjectTreeNode(file2.getProject(), (KtClassOrObject)declaration2, this.getSettings()));
                    continue;
                }
                if (!this.getSettings().isShowMembers()) continue;
                result2.add((AbstractTreeNode)new KtDeclarationTreeNode(this.getProject(), declaration2, this.getSettings()));
            }
        }
        return result2;
    }
}

