/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.quickfix.ChangeCoroutineSupportFix$InProject$WhenMappings;
import org.jetbrains.kotlin.idea.quickfix.EnableUnsupportedFeatureFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0010\u0011\u0012B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "getCoroutineSupport", "()Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "coroutineSupportEnabled", "", "getCoroutineSupportEnabled", "()Z", "getFamilyName", "", "getText", "Companion", "InModule", "InProject", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InProject;", "idea"})
public abstract class ChangeCoroutineSupportFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final LanguageFeature.State coroutineSupport;
    public static final Companion Companion = new Companion(null);

    protected final boolean getCoroutineSupportEnabled() {
        return Intrinsics.areEqual((Object)this.coroutineSupport, (Object)LanguageFeature.State.ENABLED) || Intrinsics.areEqual((Object)this.coroutineSupport, (Object)LanguageFeature.State.ENABLED_WITH_WARNING);
    }

    @NotNull
    public String getFamilyName() {
        return "Enable/Disable coroutine support";
    }

    @NotNull
    public String getText() {
        return Companion.getFixText(this.coroutineSupport);
    }

    @NotNull
    protected final LanguageFeature.State getCoroutineSupport() {
        return this.coroutineSupport;
    }

    private ChangeCoroutineSupportFix(PsiElement element3, LanguageFeature.State coroutineSupport) {
        super(element3);
        this.coroutineSupport = coroutineSupport;
    }

    public /* synthetic */ ChangeCoroutineSupportFix(@NotNull PsiElement element3, @NotNull LanguageFeature.State coroutineSupport, DefaultConstructorMarker $constructor_marker) {
        this(element3, coroutineSupport);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InModule;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "element", "Lcom/intellij/psi/PsiElement;", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    public static final class InModule
    extends ChangeCoroutineSupportFix {
        @Override
        @NotNull
        public String getText() {
            return "" + super.getText() + " in the current module";
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            Module module;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file2));
            if (module2 == null) {
                return;
            }
            Module module3 = module = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            ConfigureKotlinInProjectUtilsKt.findApplicableConfigurator(module3).changeCoroutineConfiguration(module, this.getCoroutineSupport());
        }

        public InModule(@NotNull PsiElement element3, @NotNull LanguageFeature.State coroutineSupport) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)coroutineSupport, (String)"coroutineSupport");
            super(element3, coroutineSupport, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$InProject;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix;", "element", "Lcom/intellij/psi/PsiElement;", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    public static final class InProject
    extends ChangeCoroutineSupportFix {
        @Override
        @NotNull
        public String getText() {
            return "" + super.getText() + " in the project";
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            if (this.getCoroutineSupportEnabled() && !EnableUnsupportedFeatureFixKt.checkUpdateRuntime(project, LanguageFeature.Coroutines.getSinceApiVersion())) {
                return;
            }
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project).update((Function1)new Function1<CommonCompilerArguments, Unit>(this){
                final /* synthetic */ InProject this$0;

                public final void invoke(@NotNull CommonCompilerArguments $receiver) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    switch (ChangeCoroutineSupportFix$InProject$WhenMappings.$EnumSwitchMapping$0[this.this$0.getCoroutineSupport().ordinal()]) {
                        case 1: {
                            string = "enable";
                            break;
                        }
                        case 2: {
                            string = "warn";
                            break;
                        }
                        case 3: 
                        case 4: {
                            string = "error";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    $receiver.setCoroutinesState(string);
                }
                {
                    this.this$0 = inProject;
                    super(1);
                }
            });
            ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange((Runnable)invoke.2.INSTANCE, false, true);
        }

        public InProject(@NotNull PsiElement element3, @NotNull LanguageFeature.State coroutineSupport) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)coroutineSupport, (String)"coroutineSupport");
            super(element3, coroutineSupport, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeCoroutineSupportFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getFixText", "", "state", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        @NotNull
        public final String getFixText(@NotNull LanguageFeature.State state) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            switch (ChangeCoroutineSupportFix$Companion$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    string = "Enable coroutine support";
                    break;
                }
                case 2: {
                    string = "Enable coroutine support (with warning)";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Disable coroutine support";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Module module;
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.EXPERIMENTAL_FEATURE_ERROR)) {
                Object d = Errors.EXPERIMENTAL_FEATURE_ERROR.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.EXPERIMENTAL_FEATURE_ERROR.cast(diagnostic)");
                if (Intrinsics.areEqual((Object)((Object)((LanguageFeature)((Object)((Pair)((DiagnosticWithParameters1)d).getA()).getFirst()))), (Object)((Object)LanguageFeature.Coroutines)) ^ true) {
                    return CollectionsKt.emptyList();
                }
                list2 = CollectionsKt.listOf((Object[])new LanguageFeature.State[]{LanguageFeature.State.ENABLED_WITH_WARNING, LanguageFeature.State.ENABLED});
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.EXPERIMENTAL_FEATURE_WARNING)) {
                Object d = Errors.EXPERIMENTAL_FEATURE_WARNING.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.EXPERIMENTAL_FEAT\u2026_WARNING.cast(diagnostic)");
                if (Intrinsics.areEqual((Object)((Object)((LanguageFeature)((Object)((Pair)((DiagnosticWithParameters1)d).getA()).getFirst()))), (Object)((Object)LanguageFeature.Coroutines)) ^ true) {
                    return CollectionsKt.emptyList();
                }
                list2 = CollectionsKt.listOf((Object[])new LanguageFeature.State[]{LanguageFeature.State.ENABLED, LanguageFeature.State.ENABLED_WITH_ERROR});
            } else {
                return CollectionsKt.emptyList();
            }
            List newCoroutineSupports = list2;
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)diagnostic.getPsiElement());
            if (module2 == null) {
                return CollectionsKt.emptyList();
            }
            Module module3 = module = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
            Object object = KotlinFacet.Companion.get(module3);
            KotlinFacetSettings facetSettings = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? ((KotlinFacetConfiguration)object).getSettings() : null;
            boolean configureInProject = (facetSettings == null || facetSettings.getUseProjectSettings()) && !KotlinPluginUtil.isGradleModule(module) && !KotlinPluginUtil.isMavenModule(module);
            Function2 quickFixConstructor2 = configureInProject ? (Function2)doCreateActions.quickFixConstructor.1.INSTANCE : (Function2)doCreateActions.quickFixConstructor.2.INSTANCE;
            Iterable iterable = $receiver$iv = (Iterable)newCoroutineSupports;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                LanguageFeature.State state = (LanguageFeature.State)item$iv$iv;
                Collection collection = destination$iv$iv;
                PsiElement psiElement2 = diagnostic.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                ChangeCoroutineSupportFix changeCoroutineSupportFix = (ChangeCoroutineSupportFix)quickFixConstructor2.invoke((Object)psiElement2, (Object)it);
                collection.add(changeCoroutineSupportFix);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

