/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualClassFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualFunctionFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualPropertyFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  *\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001 B>\b\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012%\u0010\u0007\u001a!\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0007\u001a!\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0002\b\u000bX\u0088\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003!\"#\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix;", "D", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "declaration", "actualPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "generateIt", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;Lkotlin/jvm/functions/Function3;)V", "elementType", "", "getElementType", "()Ljava/lang/String;", "getFamilyName", "getOrCreateImplementationFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getText", "implementationModuleOf", "Lcom/intellij/openapi/module/Module;", "expectedModule", "invoke", "", "project", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "startInWriteAction", "", "Companion", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualClassFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFunctionFix;", "idea"})
public abstract class CreateActualFix<D extends KtNamedDeclaration>
extends KotlinQuickFixAction<D> {
    private final MultiTargetPlatform.Specific actualPlatform;
    private final Function3<KtPsiFactory, Project, D, D> generateIt;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    protected abstract String getElementType();

    @NotNull
    public String getText() {
        return "Create actual " + this.getElementType() + " for platform " + this.actualPlatform.getPlatform();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected final void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration element3 = ktNamedDeclaration;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtFile ktFile = this.getOrCreateImplementationFile();
        if (ktFile == null) {
            return;
        }
        KtFile actualFile = ktFile;
        KtNamedDeclaration ktNamedDeclaration2 = (KtNamedDeclaration)this.generateIt.invoke((Object)factory2, (Object)project, (Object)element3);
        if (ktNamedDeclaration2 == null) {
            return;
        }
        KtNamedDeclaration generated = ktNamedDeclaration2;
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(actualFile, file2, factory2, generated, project){
            final /* synthetic */ KtFile $actualFile;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ KtPsiFactory $factory;
            final /* synthetic */ KtNamedDeclaration $generated;
            final /* synthetic */ Project $project;

            @Nullable
            public final Unit invoke() {
                Unit unit;
                PsiElement reformatted;
                KtPackageDirective ktPackageDirective = this.$actualFile.getPackageDirective();
                KtPackageDirective ktPackageDirective2 = this.$file.getPackageDirective();
                if (Intrinsics.areEqual((Object)(ktPackageDirective != null ? ktPackageDirective.getFqName() : null), (Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null)) ^ true && this.$actualFile.getDeclarations().isEmpty()) {
                    KtPackageDirective packageDirective;
                    KtPackageDirective ktPackageDirective3 = packageDirective = this.$file.getPackageDirective();
                    if (ktPackageDirective3 != null) {
                        KtPackageDirective ktPackageDirective4;
                        KtPackageDirective it = ktPackageDirective4 = ktPackageDirective3;
                        KtPackageDirective oldPackageDirective = this.$actualFile.getPackageDirective();
                        FqName fqName2 = it.getFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"it.fqName");
                        KtPackageDirective newPackageDirective = this.$factory.createPackageDirective(fqName2);
                        if (oldPackageDirective != null) {
                            oldPackageDirective.replace(newPackageDirective);
                        } else {
                            this.$actualFile.add(newPackageDirective);
                        }
                    }
                }
                PsiElement psiElement2 = this.$actualFile.add(this.$generated);
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                KtElement actualDeclaration = (KtElement)psiElement2;
                PsiElement psiElement3 = reformatted = CodeStyleManager.getInstance((Project)this.$project).reformat((PsiElement)actualDeclaration);
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                KtElement shortened = ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement3, null, 2, null);
                Editor editor = EditorHelper.openInEditor((PsiElement)((PsiElement)shortened));
                if (editor != null && (editor = editor.getCaretModel()) != null) {
                    TextRange textRange = shortened.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"shortened.textRange");
                    editor.moveToOffset(textRange.getStartOffset());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.$actualFile = ktFile;
                this.$file = ktFile2;
                this.$factory = ktPsiFactory;
                this.$generated = ktNamedDeclaration;
                this.$project = project;
                super(0);
            }
        });
    }

    private final Module implementationModuleOf(Module expectedModule) {
        Object v0;
        block1: {
            Iterable $receiver$iv = FacetUtilsKt.getImplementingModules(expectedModule);
            for (Object element$iv : $receiver$iv) {
                Module it = (Module)element$iv;
                if (!(PackageUtil.checkSourceRootsConfigured((Module)it, (boolean)false) && Intrinsics.areEqual((Object)TargetPlatformDetector.getPlatform(it).getMultiTargetPlatform(), (Object)this.actualPlatform))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final KtFile getOrCreateImplementationFile() {
        Module expectedModule;
        Object t = this.getElement();
        if (!(t instanceof KtNamedDeclaration)) {
            t = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)t;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        String string = declaration2.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        PsiFile psiFile = declaration2.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"declaration.containingFile");
        PsiDirectory expectedDir = psiFile.getContainingDirectory();
        PsiPackage expectedPackage = JavaDirectoryService.getInstance().getPackage(expectedDir);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)declaration2);
        if (module == null) {
            return null;
        }
        Module module2 = expectedModule = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"expectedModule");
        Module module3 = this.implementationModuleOf(module2);
        if (module3 == null) {
            return null;
        }
        Module actualModule = module3;
        Object object = expectedPackage;
        if (object == null || (object = object.getQualifiedName()) == null) {
            object = "";
        }
        PsiDirectory psiDirectory = PackageUtil.findOrCreateDirectoryForPackage((Module)actualModule, (String)object, null, (boolean)false);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory actualDirectory = psiDirectory;
        return (KtFile)ApplicationUtilsKt.runWriteAction((Function0)new Function0<KtFile>(name2, actualDirectory, declaration2){
            final /* synthetic */ String $name;
            final /* synthetic */ PsiDirectory $actualDirectory;
            final /* synthetic */ KtNamedDeclaration $declaration;

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final KtFile invoke() {
                KtFile ktFile;
                String packageName;
                String string;
                KtPackageDirective packageDirective;
                String fileName = "" + this.$name + ".kt";
                PsiFile existingFile = this.$actualDirectory.findFile(fileName);
                KtPackageDirective ktPackageDirective = packageDirective = this.$declaration.getContainingKtFile().getPackageDirective();
                if ((ktPackageDirective != null ? ktPackageDirective.getPackageNameExpression() : null) == null) {
                    PsiDirectory psiDirectory = this.$actualDirectory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"actualDirectory");
                    PsiPackage psiPackage = PackageUtilsKt.getPackage(psiDirectory);
                    string = psiPackage != null ? psiPackage.getQualifiedName() : null;
                } else {
                    string = packageName = packageDirective.getFqName().asString();
                }
                if (!(existingFile instanceof KtFile)) {
                    PsiDirectory psiDirectory = this.$actualDirectory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"actualDirectory");
                    ktFile = KotlinRefactoringUtilKt.createKotlinFile(fileName, psiDirectory, packageName);
                    return ktFile;
                }
                KtPackageDirective existingPackageDirective = ((KtFile)existingFile).getPackageDirective();
                Collection collection = ((KtFile)existingFile).getDeclarations();
                if (!collection.isEmpty()) {
                    KtPackageDirective ktPackageDirective2 = existingPackageDirective;
                    KtPackageDirective ktPackageDirective3 = packageDirective;
                    if (Intrinsics.areEqual((Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null), (Object)(ktPackageDirective3 != null ? ktPackageDirective3.getFqName() : null)) ^ true) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = this.$name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                        String newName2 = stringBuilder.append(KotlinNameSuggester.INSTANCE.suggestNameByName(string2, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){
                            final /* synthetic */ getOrCreateImplementationFile.1 this$0;

                            public final boolean invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.this$0.$actualDirectory.findFile("" + it + ".kt") == null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }))).append(".kt").toString();
                        PsiDirectory psiDirectory = this.$actualDirectory;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"actualDirectory");
                        ktFile = KotlinRefactoringUtilKt.createKotlinFile(newName2, psiDirectory, packageName);
                        return ktFile;
                    }
                }
                ktFile = (KtFile)existingFile;
                return ktFile;
            }
            {
                this.$name = string;
                this.$actualDirectory = psiDirectory;
                this.$declaration = ktNamedDeclaration;
                super(0);
            }
        });
    }

    private CreateActualFix(D declaration2, MultiTargetPlatform.Specific actualPlatform, Function3<? super KtPsiFactory, ? super Project, ? super D, ? extends D> generateIt) {
        super((PsiElement)declaration2);
        this.actualPlatform = actualPlatform;
        this.generateIt = generateIt;
    }

    public /* synthetic */ CreateActualFix(@NotNull KtNamedDeclaration declaration2, @NotNull MultiTargetPlatform.Specific actualPlatform, @NotNull Function3 generateIt, DefaultConstructorMarker $constructor_marker) {
        this(declaration2, actualPlatform, generateIt);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Map compatibility;
            DiagnosticWithParameters3 d;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters3 diagnosticWithParameters3 = d = (DiagnosticWithParameters3)DiagnosticFactory.cast(diagnostic, Errors.NO_ACTUAL_FOR_EXPECT);
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticWithParameters3, (String)"d");
            Object e = diagnosticWithParameters3.getPsiElement();
            if (!(e instanceof KtNamedDeclaration)) {
                e = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)e;
            if (ktNamedDeclaration == null) {
                return null;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            Map map2 = compatibility = (Map)d.getC();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"compatibility");
            Map map3 = map2;
            if (!map3.isEmpty() && !(declaration2 instanceof KtFunction)) {
                return null;
            }
            Object b = d.getB();
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"d.b");
            MultiTargetPlatform multiTargetPlatform = MultiTargetPlatformKt.getMultiTargetPlatform((ModuleDescriptor)b);
            if (!(multiTargetPlatform instanceof MultiTargetPlatform.Specific)) {
                multiTargetPlatform = null;
            }
            MultiTargetPlatform.Specific specific = (MultiTargetPlatform.Specific)multiTargetPlatform;
            if (specific == null) {
                return null;
            }
            MultiTargetPlatform.Specific actualPlatform = specific;
            KtNamedDeclaration ktNamedDeclaration2 = declaration2;
            return ktNamedDeclaration2 instanceof KtClassOrObject ? (IntentionAction)new CreateActualClassFix((KtClassOrObject)declaration2, actualPlatform) : (ktNamedDeclaration2 instanceof KtFunction ? (IntentionAction)new CreateActualFunctionFix((KtFunction)declaration2, actualPlatform) : (ktNamedDeclaration2 instanceof KtProperty ? (IntentionAction)new CreateActualPropertyFix((KtProperty)declaration2, actualPlatform) : null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

