/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.common.Symbol;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsFunction
extends JsLiteral
implements HasName {
    @NotNull
    private JsBlock body;
    private List<JsParameter> params;
    @NotNull
    private final JsFunctionScope scope;
    private JsName name;

    public JsFunction(@NotNull JsScope parentScope, @NotNull String description2) {
        this(parentScope, description2, null);
    }

    public JsFunction(@NotNull JsScope parentScope, @NotNull JsBlock body2, @NotNull String description2) {
        this(parentScope, description2, null);
        this.body = body2;
    }

    private JsFunction(@NotNull JsScope parentScope, @NotNull String description2, @Nullable JsName name2) {
        this.name = name2;
        this.scope = new JsFunctionScope(parentScope, name2 == null ? description2 : name2.getIdent());
    }

    @NotNull
    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @Override
    public Symbol getSymbol() {
        return this.name;
    }

    @NotNull
    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList();
        }
        return this.params;
    }

    @NotNull
    public JsFunctionScope getScope() {
        return this.scope;
    }

    public void setBody(@NotNull JsBlock body2) {
        this.body = body2;
    }

    @Override
    public void setName(@Nullable JsName name2) {
        this.name = name2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFunction(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.getParameters());
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.getParameters());
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsFunction deepCopy() {
        JsFunction functionCopy = new JsFunction(this.scope.getParent(), this.scope.getDescription(), this.name);
        functionCopy.getScope().copyOwnNames(this.scope);
        functionCopy.setBody(this.body.deepCopy());
        functionCopy.params = AstUtil.deepCopy(this.params);
        return functionCopy.withMetadataFrom(this);
    }
}

