/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.findDocComment.FindDocCommentKt;

public abstract class KtDeclarationImpl
extends KtExpressionImpl
implements KtDeclaration {
    public KtDeclarationImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return (KtModifierList)this.findChildByType(KtNodeTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifier) {
        KtModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        AddRemoveModifierKt.addModifier(this, modifier);
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        AddRemoveModifierKt.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        return AddRemoveModifierKt.addAnnotationEntry(this, annotationEntry2);
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getAnnotationEntries() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        return modifierList.getAnnotationEntries();
    }

    @Override
    @NotNull
    public List<KtAnnotation> getAnnotations() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            return Collections.emptyList();
        }
        return modifierList.getAnnotations();
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentKt.findDocComment(this);
    }
}

