/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.mvc;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CorsMappingAllowedMethodsConverter
extends DelimitedListConverter<RequestMethod> {
    private static final String ANY_METHOD = "*";
    private static final EnumSet<RequestMethod> DEFAULT_REQUEST_METHODS = EnumSet.of(RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST);

    public CorsMappingAllowedMethodsConverter() {
        super(",");
    }

    @Nullable
    protected RequestMethod convertString(@Nullable String string, ConvertContext context) {
        String value = StringUtil.trim((String)string);
        if (ANY_METHOD.equals(value)) {
            return RequestMethod.GET;
        }
        for (RequestMethod method : RequestMethod.values()) {
            if (!method.name().equals(value)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    protected String toString(@Nullable RequestMethod method) {
        return method != null ? method.name() : null;
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<List<RequestMethod>> genericDomValue) {
        return CorsMappingAllowedMethodsConverter.getVariants();
    }

    @NotNull
    public static Object[] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(RequestMethod.values().length);
        for (RequestMethod method : RequestMethod.values()) {
            boolean isEnabledByDefault = DEFAULT_REQUEST_METHODS.contains(method);
            variants.add(LookupElementBuilder.create((String)method.name()).withBoldness(isEnabledByDefault));
        }
        variants.add(LookupElementBuilder.create((String)ANY_METHOD).withTailText(" (all)", true));
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            CorsMappingAllowedMethodsConverter.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable RequestMethod method, ConvertContext context) {
        return method != null ? context.getXmlElement() : null;
    }

    protected String getUnresolvedMessage(String value) {
        return "Invalid method '" + value + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/mvc/CorsMappingAllowedMethodsConverter", "getVariants"));
    }
}

