/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import icons.SpringApiIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoSpringRequestMappingSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            GotoSpringRequestMappingSymbolProvider.$$$reportNull$$$0(0);
        }
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, (Processor<SpringMVCModel>)((Processor)model -> {
            List urls = model.getAllUrls();
            for (SpringMVCModel.Variant variant : urls) {
                result.add("/" + variant.getPresentation());
            }
            return true;
        }));
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            GotoSpringRequestMappingSymbolProvider.$$$reportNull$$$0(1);
        }
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'/')) {
            return;
        }
        String nameWithoutPrefix = name.substring(1);
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, (Processor<SpringMVCModel>)((Processor)model -> {
            for (final SpringMVCModel.Variant variant : model.getAllUrls()) {
                PsiElement target;
                if (!nameWithoutPrefix.equals(variant.getPresentation()) || (target = variant.getPsiElementPointer().getPsiElement()) == null) continue;
                result.add((NavigationItem)new GoToSymbolProvider.BaseNavigationItem(target, "/" + variant.getPresentation(), SpringApiIcons.RequestMapping){

                    public ItemPresentation getPresentation() {
                        final ItemPresentation original = super.getPresentation();
                        assert (original != null);
                        return new ItemPresentation(){

                            public String getPresentableText() {
                                return original.getPresentableText();
                            }

                            @Nullable
                            public String getLocationString() {
                                String requestMethods = variant.getMethod().length != 0 ? " " + RequestMethod.getDisplay((RequestMethod[])variant.getMethod()) : "";
                                return original.getLocationString() + requestMethods;
                            }

                            @Nullable
                            public Icon getIcon(boolean open) {
                                return original.getIcon(open);
                            }
                        };
                    }
                });
            }
            return true;
        }));
    }

    protected boolean acceptModule(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module) && !WebFacet.getInstances((Module)module).isEmpty() && SpringMvcLibraryUtil.hasSpringMvcLibrary((Module)module);
    }

    private static void processSpringMvcModel(@NotNull Module module, Processor<SpringMVCModel> modelProcessor) {
        if (module == null) {
            GotoSpringRequestMappingSymbolProvider.$$$reportNull$$$0(2);
        }
        SpringFacet springFacet = (SpringFacet)ObjectUtils.assertNotNull((Object)SpringFacet.getInstance((Module)module));
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringMVCModel springMvcModel = SpringMVCModelService.getInstance().getModel(webFacet, springFacet);
            if (springMvcModel == null) continue;
            modelProcessor.process((Object)springMvcModel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processSpringMvcModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

