/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlBasedViewResolver
extends ViewResolver.WithPrefixSuffix {
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;
    @NotNull
    private final String myID;

    UrlBasedViewResolver(@NotNull String ID, @Nullable String prefix, @Nullable String suffix) {
        if (ID == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(0);
        }
        this.myID = ID;
        this.myPrefix = StringUtil.notNullize((String)prefix);
        this.mySuffix = StringUtil.notNullize((String)suffix);
    }

    private boolean isClasspathPrefix() {
        return StringUtil.startsWith((CharSequence)this.myPrefix, (CharSequence)"classpath:");
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement resolveView(@NotNull PsiElement context, String viewName, SpringMVCModel springMVCModel) {
        if (context == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(2);
        }
        if (this.isClasspathPrefix()) {
            return this.resolveViewForClasspath(context, viewName);
        }
        String path = this.myPrefix + viewName + this.mySuffix;
        WebDirectoryElement element = springMVCModel.findWebDirectoryElement(path);
        return element == null ? null : element.getOriginalFile();
    }

    @Nullable
    private PsiElement resolveViewForClasspath(@NotNull PsiElement context, String viewName) {
        if (context == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(3);
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)context.getContainingFile(), (String)(this.myPrefix + viewName + this.mySuffix), (int)1);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
        Collection items = SpringResourcesUtil.getInstance().getResourceItems(references, Conditions.alwaysTrue());
        return (PsiElement)ContainerUtil.getFirstItem((Collection)items);
    }

    public List<LookupElement> getAllViews(@NotNull PsiElement context, SpringMVCModel springMVCModel) {
        if (context == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(4);
        }
        if (this.isClasspathPrefix()) {
            return this.getAllViewsForClasspath(context);
        }
        WebDirectoryElement element = springMVCModel.findWebDirectoryElement(this.myPrefix);
        if (element == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull((Object[])element.getChildren(), (Function)((NullableFunction)webDirectoryElement -> {
            String name = webDirectoryElement.getName();
            if (!name.endsWith(this.mySuffix)) {
                return null;
            }
            name = name.substring(0, name.length() - this.mySuffix.length());
            return LookupElementBuilder.create((String)name).withIcon(webDirectoryElement.getIcon(0)).withTailText(" (" + webDirectoryElement.getPath() + ")", true);
        }));
    }

    @NotNull
    private List<LookupElement> getAllViewsForClasspath(@NotNull PsiElement context) {
        if (context == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(5);
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)context.getContainingFile(), (String)this.myPrefix, (int)1).endingSlashNotAllowed(false);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
        Collection directories = SpringResourcesUtil.getInstance().getResourceItems(references, PsiFileSystemItem::isDirectory);
        SmartList variants = new SmartList();
        for (PsiFileSystemItem directory : directories) {
            for (VirtualFile file : directory.getVirtualFile().getChildren()) {
                PsiFile psiFile;
                String fileName = file.getName();
                if (!fileName.endsWith(this.mySuffix) || (psiFile = context.getManager().findFile(file)) == null) continue;
                String viewName = fileName.substring(0, fileName.length() - this.mySuffix.length());
                variants.add(LookupElementBuilder.create((String)viewName).withIcon(psiFile.getIcon(0)).withTailText(" (" + fileName + ")", true));
            }
        }
        SmartList smartList = variants;
        if (smartList == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    public String bindToElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        WebDirectoryElement webDirectoryElement = WebUtil.findWebDirectoryByFile((PsiFileSystemItem)((PsiFile)element));
        if (webDirectoryElement == null) {
            return null;
        }
        String path = webDirectoryElement.getPath();
        if (path.startsWith(this.myPrefix) && path.endsWith(this.mySuffix)) {
            return path.substring(this.myPrefix.length(), path.length() - this.mySuffix.length());
        }
        return path;
    }

    @NotNull
    public String handleElementRename(String path) {
        String string = path = StringUtil.trimEnd((String)path, (String)this.mySuffix);
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    WebDirectoryElement getRoot(SpringMVCModel model) {
        return model.findWebDirectoryElement(this.myPrefix);
    }

    @Nullable
    String encode(String name) {
        if (name.length() > this.mySuffix.length()) {
            return name.substring(0, name.length() - this.mySuffix.length());
        }
        return null;
    }

    String decode(String name) {
        return name + this.mySuffix;
    }

    public String toString() {
        return "UrlBasedViewResolver{myPrefix='" + this.myPrefix + '\'' + ", mySuffix='" + this.mySuffix + '\'' + '}';
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViewsForClasspath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveView";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveViewForClasspath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllViews";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllViewsForClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

