/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfigurationBase;
import com.intellij.javaee.facet.JavaeeFacetEditorValidator;
import com.intellij.javaee.module.view.web.WebFacetEditor;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class WebFacetConfigurationImpl
extends JavaeeFacetConfigurationBase
implements WebFacetConfiguration {
    private List<WebRootData> myWebRoots = new ArrayList<WebRootData>();
    private List<String> mySourceRoots = new ArrayList<String>();

    public WebFacetConfigurationImpl(ConfigFileMetaDataProvider metaDataProvider) {
        super(metaDataProvider);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        WebFacetImpl webFacet = (WebFacetImpl)context.getFacet();
        validatorsManager.registerValidator((FacetEditorValidator)new JavaeeFacetEditorValidator((JavaeeFacet)webFacet, context), new JComponent[0]);
        WebFacetEditor facetEditor = new WebFacetEditor(webFacet, context, validatorsManager);
        return new FacetEditorTab[]{facetEditor};
    }

    @Override
    @NotNull
    public List<WebRootData> getWebRoots() {
        List<WebRootData> list = Collections.unmodifiableList(this.myWebRoots);
        if (list == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    public List<String> getSourceRoots() {
        return this.mySourceRoots;
    }

    public void setSourceRoots(List<String> sourceRoots) {
        this.mySourceRoots = new ArrayList<String>(sourceRoots);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Element sourceRoots;
        if (element == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(1);
        }
        this.myWebRoots.clear();
        this.mySourceRoots.clear();
        Element webRootsElement = element.getChild("webroots");
        if (webRootsElement != null) {
            for (Element root : webRootsElement.getChildren("root")) {
                this.myWebRoots.add(new WebRootData(root));
            }
        }
        if ((sourceRoots = element.getChild("sourceRoots")) != null) {
            for (Element rootElement : sourceRoots.getChildren("root")) {
                this.mySourceRoots.add(rootElement.getAttributeValue("url"));
            }
        }
        super.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element roots = new Element("webroots");
        for (WebRootData webRoot : this.myWebRoots) {
            Element root = new Element("root");
            webRoot.writeExternal(root);
            roots.addContent(root);
        }
        element.addContent(roots);
        Element sourceRoots = new Element("sourceRoots");
        for (String sourceRoot : this.mySourceRoots) {
            sourceRoots.addContent(new Element("root").setAttribute("url", sourceRoot));
        }
        element.addContent(sourceRoots);
    }

    public void setWebRoots(@NotNull List<WebRootData> webRoots) {
        if (webRoots == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(2);
        }
        this.myWebRoots = new ArrayList<WebRootData>(webRoots);
    }

    public void addWebRoot(@NotNull WebRootData root) {
        if (root == null) {
            WebFacetConfigurationImpl.$$$reportNull$$$0(3);
        }
        this.myWebRoots.add(root);
    }

    public void removeWebRoot(WebRootData webRootData) {
        this.myWebRoots.remove(webRootData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/facet/WebFacetConfigurationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebRoots";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/facet/WebFacetConfigurationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setWebRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addWebRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

