/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.EntityListenerBindingsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;

public class EditEntityListenerBindingsAction
extends AnAction {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        EntityListener target = (EntityListener)dataContext.getData("EntityListenerImpl");
        boolean enabled = project != null && target != null && target.getClazz().getValue() != null && target.getModule() != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        EntityListener target = (EntityListener)dataContext.getData("EntityListenerImpl");
        assert (target != null);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        JpaFacet facet = JpaUtil.getJpaFacet(target.getModule());
        assert (facet != null);
        PsiClass psiClass = (PsiClass)target.getClazz().getValue();
        assert (psiClass != null);
        EntityListenerBindingsDialog dialog = new EntityListenerBindingsDialog(project, psiClass.getQualifiedName(), facet);
        dialog.show();
    }
}

