/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.javaee.model.common.persistence.mapping.ManyToMany;
import com.intellij.javaee.model.common.persistence.mapping.PersistentObject;
import com.intellij.javaee.model.common.persistence.mapping.RelationAttributeBase;
import com.intellij.javaee.util.AnnotationManipulator;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.jpa.model.annotations.mapping.JamRelationAttributeBase;
import com.intellij.jpa.model.manipulators.AttributeManipulatorBase;
import com.intellij.jpa.model.manipulators.JpaAnnoObjectManipulator;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JpaAnnoRelationshipAttributeManipulator
extends AttributeManipulatorBase<JamRelationAttributeBase>
implements PersistentRelationshipAttributeManipulator<JamRelationAttributeBase> {
    public JpaAnnoRelationshipAttributeManipulator(JamRelationAttributeBase target) {
        super(target);
    }

    public void setMappedByAndInverse(String name, boolean inverse) throws IncorrectOperationException {
        if (!(this.getManipulatorTarget() instanceof RelationAttributeBase.NonManyToOneBase)) {
            return;
        }
        JamRelationAttributeBase attribute = (JamRelationAttributeBase)this.getManipulatorTarget();
        if (inverse && attribute instanceof RelationAttributeBase.NonManyToOneBase) {
            ((JamStringAttributeElement)((RelationAttributeBase.NonManyToOneBase)attribute).getMappedBy()).setStringValue(name);
        }
    }

    public void setMapKeyColumn(String attributeName, DasColumn columnInfo, boolean inverse) throws IncorrectOperationException {
        JamRelationAttributeBase target = (JamRelationAttributeBase)this.getManipulatorTarget();
        assert (target instanceof RelationAttributeBase.AnyToManyBase);
        PsiMember psiMember = target.getPsiMember();
        ((JamStringAttributeElement)((RelationAttributeBase.AnyToManyBase)target).getMapKey().getTargetAttribute()).setStringValue(attributeName);
    }

    public void setJoinTable(boolean inverse, DasTable joinTable, Map<DasColumn, DasColumn> sourceColumnsMap, Map<DasColumn, DasColumn> targetColumnsMap) throws IncorrectOperationException {
        if (inverse) {
            return;
        }
        JamRelationAttributeBase target = (JamRelationAttributeBase)this.getManipulatorTarget();
        PsiMember psiMember = target.getPsiMember();
        String joinColumns = AnnotationTextUtil.createStringArrayInitializer(JpaAnnoRelationshipAttributeManipulator.createColumnsAnnosList(sourceColumnsMap, psiMember, joinTable.getName()), new String[0]);
        String inverseJoinColumns = AnnotationTextUtil.createStringArrayInitializer(JpaAnnoRelationshipAttributeManipulator.createColumnsAnnosList(targetColumnsMap, psiMember, joinTable.getName()), new String[0]);
        assert (psiMember != null);
        PsiAnnotation annotation = (PsiAnnotation)JpaAnnoObjectManipulator.createJpaAnnoChildLink(psiMember, "javax.persistence.JoinTable").ensurePsiElementExists();
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "name", AnnotationTextUtil.quote(joinTable.getName()), AnnotationTextUtil.quote((String)target.getName().getValue()));
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "catalog", AnnotationTextUtil.quote(DasUtil.getCatalog((DasObject)joinTable)), null);
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "schema", AnnotationTextUtil.quote(DasUtil.getSchema((DasObject)joinTable)), null);
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "joinColumns", joinColumns, null);
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "inverseJoinColumns", inverseJoinColumns, null);
        JpaAnnoObjectManipulator.setAnnotationParameter(annotation, "uniqueConstraints", null, null);
        if (annotation.getParameterList().getAttributes().length == 0) {
            annotation.delete();
        }
    }

    public void setJoinColumns(boolean inverse, Map<DasColumn, DasColumn> columnsMap) throws IncorrectOperationException {
        if (inverse) {
            return;
        }
        JamRelationAttributeBase target = (JamRelationAttributeBase)this.getManipulatorTarget();
        assert (!(target instanceof ManyToMany));
        PsiMember psiMember = target.getPsiMember();
        PersistentObject persistentObject = ((JamRelationAttributeBase)this.getManipulatorTarget()).getPersistentObject();
        PersistentEntity entity = persistentObject instanceof PersistentEntity ? (PersistentEntity)persistentObject : null;
        AnnotationTextUtil.createMultiAnnotation(JpaAnnoRelationshipAttributeManipulator.createColumnsAnnosList(columnsMap, psiMember, entity == null ? null : (String)entity.getObjectModelHelper().getTable().getTableName().getValue()), psiMember, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns", AnnotationManipulator.PSI_MANIPULATOR);
    }

    private static List<String> createColumnsAnnosList(Map<DasColumn, DasColumn> sourceColumnsMap, PsiMember psiMember, String defaultTableName) throws IncorrectOperationException {
        ArrayList<String> annoList = new ArrayList<String>();
        for (DasColumn column : sourceColumnsMap.keySet()) {
            String tableName = column.getTable().getName();
            tableName = Comparing.strEqual((String)tableName, (String)defaultTableName, (boolean)false) ? "" : tableName;
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, "javax.persistence.JoinColumn", true, null, "name", AnnotationTextUtil.quote(column.getName()), null, "referencedColumnName", AnnotationTextUtil.quote(sourceColumnsMap.get(column).getName()), null, "unique", null, null, "nullable", String.valueOf(!column.isNotNull()), null, "columnDefinition", null, null, "table", AnnotationTextUtil.quote(tableName), AnnotationTextUtil.quote(defaultTableName));
            annoList.add(text);
        }
        return annoList;
    }
}

