/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.dependencies;

import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.seam.dependencies.beans.BasicSeamDependencyInfo;
import com.intellij.seam.dependencies.beans.SeamComponentNodeInfo;
import com.intellij.seam.dependencies.beans.SeamDependencyInfo;
import com.intellij.seam.dependencies.beans.SeamDomComponentNodeInfo;
import com.intellij.seam.dependencies.beans.SeamJamComponentNodeInfo;
import com.intellij.seam.dependencies.beans.UnknownBijectionNodeInfo;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.seam.model.jam.bijection.SeamJamBijection;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamDependenciesDataModel
extends GraphDataModel<SeamComponentNodeInfo, SeamDependencyInfo> {
    private final Module myModule;
    private final Collection<SeamComponentNodeInfo> myNodes = new HashSet();
    private final Collection<SeamDependencyInfo> myEdges = new HashSet();
    protected final Map<PsiFile, NodesGroup> myGroups = new HashMap();

    public SeamDependenciesDataModel(Module module) {
        this.myModule = module;
    }

    @NotNull
    public Collection<SeamComponentNodeInfo> getNodes() {
        Collection<SeamComponentNodeInfo> collection = this.getNodes(true);
        if (collection == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<SeamComponentNodeInfo> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<SeamComponentNodeInfo> collection = this.myNodes;
        if (collection == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<SeamDependencyInfo> getEdges() {
        Collection<SeamDependencyInfo> collection = this.myEdges;
        if (collection == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public SeamComponentNodeInfo getSourceNode(SeamDependencyInfo dependencyInfo) {
        SeamComponentNodeInfo seamComponentNodeInfo = dependencyInfo.getSource();
        if (seamComponentNodeInfo == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(3);
        }
        return seamComponentNodeInfo;
    }

    @NotNull
    public SeamComponentNodeInfo getTargetNode(SeamDependencyInfo dependencyInfo) {
        SeamComponentNodeInfo seamComponentNodeInfo = dependencyInfo.getTarget();
        if (seamComponentNodeInfo == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(4);
        }
        return seamComponentNodeInfo;
    }

    @NotNull
    public String getNodeName(SeamComponentNodeInfo pageflowBasicNode) {
        if ("" == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    public String getEdgeName(SeamDependencyInfo pageflowBasicEdge) {
        String string = pageflowBasicEdge.getName();
        if (string == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    public SeamDependencyInfo createEdge(@NotNull SeamComponentNodeInfo from, @NotNull SeamComponentNodeInfo to) {
        if (from == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(7);
        }
        if (to == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(8);
        }
        return null;
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        Set<ContextVariable> contextVariables = SeamCommonUtils.getSeamContextVariablesWithDependencies(this.myModule);
        Set<SeamJamComponent> seamJamComponents = SeamJamModel.getModel(this.myModule).getSeamComponents(true);
        seamJamComponents.addAll(SeamJamModel.getModel(this.myModule).getMergedComponents(true));
        HashMap annotatedNodesMap = new HashMap();
        HashMap compiledNodesMap = new HashMap();
        HashMap domNodesMap = new HashMap();
        HashMap unknownNodesMap = new HashMap();
        ArrayList<Pair> jamComponentsInfo = new ArrayList<Pair>();
        for (SeamJamComponent component : seamJamComponents) {
            String componentName = component.getComponentName();
            PsiClass psiClass = component.getPsiElement();
            if (StringUtil.isEmptyOrSpaces((String)componentName)) continue;
            SeamJamComponentNodeInfo nodeInfo = new SeamJamComponentNodeInfo(component);
            if (psiClass instanceof PsiCompiledElement) {
                compiledNodesMap.put(componentName, nodeInfo);
            } else {
                annotatedNodesMap.put(componentName, nodeInfo);
                this.myNodes.add(nodeInfo);
            }
            jamComponentsInfo.add(Pair.create((Object)componentName, (Object)component.getComponentType()));
        }
        HashMap domFactoriesMap = new HashMap();
        for (SeamDomModel model : SeamDomModelManager.getInstance(this.myModule.getProject()).getAllModels(this.myModule)) {
            for (SeamDomComponent seamDomComponent : model.getSeamComponents()) {
                String name = seamDomComponent.getComponentName();
                PsiType type = seamDomComponent.getComponentType();
                if (StringUtil.isEmptyOrSpaces((String)name) || jamComponentsInfo.contains(Pair.create((Object)name, (Object)type))) continue;
                SeamDomComponentNodeInfo nodeInfo = new SeamDomComponentNodeInfo(seamDomComponent);
                domNodesMap.put(name, nodeInfo);
                this.myNodes.add(nodeInfo);
            }
            for (SeamDomFactory domFactory : model.getFactories()) {
                String factoryName = domFactory.getFactoryName();
                if (StringUtil.isEmptyOrSpaces((String)factoryName)) continue;
                domFactoriesMap.put(factoryName, domFactory);
            }
        }
        for (SeamJamComponentNodeInfo nodeInfo : annotatedNodesMap.values()) {
            for (SeamJamInjection injection : nodeInfo.getIdentifyingElement().getInjections()) {
                SeamComponentNodeInfo source = this.getNodeByComponentName((Map<String, SeamJamComponentNodeInfo>)annotatedNodesMap, (Map<String, SeamJamComponentNodeInfo>)compiledNodesMap, (Map<String, SeamDomComponentNodeInfo>)domNodesMap, (Map<String, UnknownBijectionNodeInfo>)unknownNodesMap, injection, (Map<String, SeamDomFactory>)domFactoriesMap);
                if (source == null) continue;
                this.myEdges.add(new BasicSeamDependencyInfo(source, nodeInfo, "@In", injection));
            }
            for (SeamJamOutjection outjection : nodeInfo.getIdentifyingElement().getOutjections()) {
                SeamComponentNodeInfo target = this.getNodeByComponentName((Map<String, SeamJamComponentNodeInfo>)annotatedNodesMap, (Map<String, SeamJamComponentNodeInfo>)compiledNodesMap, (Map<String, SeamDomComponentNodeInfo>)domNodesMap, (Map<String, UnknownBijectionNodeInfo>)unknownNodesMap, outjection, (Map<String, SeamDomFactory>)domFactoriesMap);
                if (target == null) continue;
                this.myEdges.add(new BasicSeamDependencyInfo(nodeInfo, target, "@Out", outjection));
            }
        }
    }

    @Nullable
    private SeamComponentNodeInfo getNodeByComponentName(Map<String, SeamJamComponentNodeInfo> nodesMap, Map<String, SeamJamComponentNodeInfo> compiledNodesMap, Map<String, SeamDomComponentNodeInfo> domNodesMap, Map<String, UnknownBijectionNodeInfo> unknownNodesMap, SeamJamBijection bijection, Map<String, SeamDomFactory> domFactoriesMap) {
        String name = bijection.getName();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        SeamComponentNodeInfo componentNodeInfo = this.findNodeByName(name, nodesMap, domNodesMap, compiledNodesMap, domFactoriesMap);
        return componentNodeInfo == null ? this.getOrCreateUnknownNode(bijection, name, unknownNodesMap) : componentNodeInfo;
    }

    @Nullable
    private SeamComponentNodeInfo findNodeByName(@NotNull String name, Map<String, SeamJamComponentNodeInfo> nodesMap, Map<String, SeamDomComponentNodeInfo> domNodesMap, Map<String, SeamJamComponentNodeInfo> compiledNodesMap, Map<String, SeamDomFactory> domFactoriesMap) {
        if (name == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(9);
        }
        return this.findNodeByName(name, nodesMap, domNodesMap, compiledNodesMap, domFactoriesMap, (Set<String>)new HashSet());
    }

    @Nullable
    private SeamComponentNodeInfo findNodeByName(@NotNull String name, Map<String, SeamJamComponentNodeInfo> nodesMap, Map<String, SeamDomComponentNodeInfo> domNodesMap, Map<String, SeamJamComponentNodeInfo> compiledNodesMap, Map<String, SeamDomFactory> domFactoriesMap, Set<String> processedNames) {
        String aliasedVarName;
        if (name == null) {
            SeamDependenciesDataModel.$$$reportNull$$$0(10);
        }
        if (nodesMap.containsKey(name)) {
            return nodesMap.get(name);
        }
        for (SeamJamComponentNodeInfo info : nodesMap.values()) {
            for (SeamJamRole role : info.getIdentifyingElement().getRoles()) {
                if (!name.equals(role.getName())) continue;
                return info;
            }
        }
        if (domNodesMap.containsKey(name)) {
            return domNodesMap.get(name);
        }
        if (compiledNodesMap.containsKey(name)) {
            SeamJamComponentNodeInfo source = compiledNodesMap.get(name);
            this.myNodes.add(source);
            return source;
        }
        if (domFactoriesMap.containsKey(name) && !StringUtil.isEmptyOrSpaces((String)(aliasedVarName = SeamCommonUtils.getFactoryAliasedVarName(domFactoriesMap.get(name)))) && !processedNames.contains(aliasedVarName)) {
            processedNames.add(name);
            return this.findNodeByName(aliasedVarName, nodesMap, domNodesMap, compiledNodesMap, domFactoriesMap, processedNames);
        }
        return null;
    }

    private SeamComponentNodeInfo getOrCreateUnknownNode(SeamJamBijection bijection, String name, Map<String, UnknownBijectionNodeInfo> unknownNodesMap) {
        if (unknownNodesMap.containsKey(name)) {
            return unknownNodesMap.get(name);
        }
        UnknownBijectionNodeInfo unknownBijectionNodeInfo = new UnknownBijectionNodeInfo(bijection);
        unknownNodesMap.put(name, unknownBijectionNodeInfo);
        this.myNodes.add(unknownBijectionNodeInfo);
        return unknownBijectionNodeInfo;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/dependencies/SeamDependenciesDataModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/dependencies/SeamDependenciesDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

