/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.bijection.SeamJamBijection;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamBijectionUndefinedContextVariableInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamJamComponent, ProblemsHolder holder) {
        Module module = seamJamComponent.getModule();
        for (SeamJamInjection injection : seamJamComponent.getInjections()) {
            SeamBijectionUndefinedContextVariableInspection.checkInjectionContextVariableExisted(holder, injection, module);
        }
        for (SeamJamOutjection outjection : seamJamComponent.getOutjections()) {
            SeamBijectionUndefinedContextVariableInspection.checkOutjectionContextVariableExisted(holder, outjection, module);
        }
    }

    private static void checkInjectionContextVariableExisted(ProblemsHolder holder, SeamJamInjection baseSeamInjection, Module module) {
        SeamBijectionUndefinedContextVariableInspection.checkContextVariableExisted(holder, baseSeamInjection, module);
    }

    private static void checkOutjectionContextVariableExisted(ProblemsHolder holder, SeamJamOutjection outjection, Module module) {
        SeamComponentScope scope = outjection.getScope();
        if (scope != null && scope != SeamComponentScope.UNSPECIFIED) {
            return;
        }
        SeamBijectionUndefinedContextVariableInspection.checkContextVariableExisted(holder, outjection, module);
    }

    private static void checkContextVariableExisted(ProblemsHolder holder, SeamJamBijection bijection, Module module) {
        String variableName = bijection.getName();
        if (variableName != null && !SeamCommonUtils.isElText(variableName) && !SeamBijectionUndefinedContextVariableInspection.isContextVariableExisted(variableName, module)) {
            holder.registerProblem((PsiElement)bijection.getIdentifyingAnnotation(), SeamInspectionBundle.message("bijection.undefined.context.variable", variableName), new LocalQuickFix[0]);
        }
    }

    private static boolean isContextVariableExisted(@NotNull String variableName, Module module) {
        if (variableName == null) {
            SeamBijectionUndefinedContextVariableInspection.$$$reportNull$$$0(0);
        }
        return SeamCommonUtils.getContextVariable(variableName, module) != null;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("bijection.undefined.context.variables.inspection.name", new Object[0]);
        if (string == null) {
            SeamBijectionUndefinedContextVariableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamBijectionUndefinedContextVariableInspection" == null) {
            SeamBijectionUndefinedContextVariableInspection.$$$reportNull$$$0(2);
        }
        return "SeamBijectionUndefinedContextVariableInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            SeamBijectionUndefinedContextVariableInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/highlighting/jam/SeamBijectionUndefinedContextVariableInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isContextVariableExisted";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

