/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequestCompositeElement;
import com.intellij.ws.http.request.psi.HttpVariable;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import org.jetbrains.annotations.NotNull;

public class HttpRequestVariableSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.HttpRequestVariableSubstitutor");
    private static final HttpRequestVariableSubstitutor EMPTY = new HttpRequestVariableSubstitutor(HttpRequestEnvironment.empty());
    private HttpRequestEnvironment myEnvironment;

    private HttpRequestVariableSubstitutor(@NotNull HttpRequestEnvironment environment) {
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(0);
        }
        this.myEnvironment = environment;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor getDefault(@NotNull Project project) {
        block4: {
            HttpRequestVariableSubstitutor httpRequestVariableSubstitutor;
            block5: {
                if (project == null) {
                    HttpRequestVariableSubstitutor.$$$reportNull$$$0(1);
                }
                try {
                    HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(project);
                    if (env == null) break block4;
                    httpRequestVariableSubstitutor = new HttpRequestVariableSubstitutor(env);
                    if (httpRequestVariableSubstitutor != null) break block5;
                }
                catch (HttpRequestValidationException e) {
                    LOG.debug((Throwable)e);
                }
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(2);
            }
            return httpRequestVariableSubstitutor;
        }
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(3);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor create(@NotNull HttpRequestEnvironment environment) {
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(4);
        }
        if (environment == HttpRequestEnvironment.empty()) {
            HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = HttpRequestVariableSubstitutor.empty();
            if (httpRequestVariableSubstitutor == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(5);
            }
            return httpRequestVariableSubstitutor;
        }
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = new HttpRequestVariableSubstitutor(environment);
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(6);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor empty() {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = EMPTY;
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(7);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(8);
        }
        String string = this.getValue(element, (Condition<PsiElement>)Conditions.alwaysTrue());
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<PsiElement> filter) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(11);
        }
        if (element instanceof HttpVariable) {
            String string = this.getVariableValue((HttpVariable)element);
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (element instanceof HttpRequestCompositeElement) {
            StringBuilder builder = new StringBuilder();
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof HttpVariable) {
                    builder.append(this.getVariableValue((HttpVariable)child));
                    continue;
                }
                if (!filter.value((Object)child)) continue;
                builder.append(child.getText());
            }
            String string = builder.toString();
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String getVariableValue(@NotNull HttpVariable variable) {
        String value;
        if (variable == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(15);
        }
        String string = StringUtil.isNotEmpty((String)(value = this.myEnvironment.getVariableValue(StringUtil.notNullize((String)variable.getName())))) ? value : variable.getText();
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

