/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LinesUtil;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class SaveHook
implements Runnable {
    private final File myDataFile;
    private File mySourceMapFile;
    private final boolean myAppendUnloaded;
    private final ClassFinder myClassFinder;

    public SaveHook(File dataFile, boolean appendUnloaded, ClassFinder classFinder) {
        this.myDataFile = dataFile;
        this.myAppendUnloaded = appendUnloaded;
        this.myClassFinder = classFinder;
    }

    public void run() {
        this.save(ProjectData.getProjectData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ProjectData projectData) {
        projectData.stop();
        try {
            if (this.myAppendUnloaded) {
                this.appendUnloaded(projectData);
            }
            DataOutputStream os = null;
            try {
                os = CoverageIOUtil.openFile((File)this.myDataFile);
                projectData.checkLineMappings();
                TObjectIntHashMap dict = new TObjectIntHashMap();
                HashMap classes = new HashMap(projectData.getClasses());
                CoverageIOUtil.writeINT((DataOutput)os, (int)classes.size());
                SaveHook.saveDictionary(os, dict, classes);
                SaveHook.saveData(os, dict, classes);
                SaveHook.saveSourceMap(classes, this.mySourceMapFile);
            }
            catch (IOException e) {
                ErrorReporter.reportError((String)("Error writing file " + this.myDataFile.getPath()), (Throwable)e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    ErrorReporter.reportError((String)("Error writing file " + this.myDataFile.getPath()), (Throwable)e);
                }
            }
        }
        catch (OutOfMemoryError e) {
            ErrorReporter.reportError((String)"Out of memory error occurred, try to increase memory available for the JVM, or make include / exclude patterns more specific", (Throwable)e);
        }
        catch (Throwable e) {
            ErrorReporter.reportError((String)"Unexpected error", (Throwable)e);
        }
    }

    public static void saveSourceMap(Map str_clData_classes, File sourceMapFile) {
        if (sourceMapFile != null) {
            Map readNames = Collections.emptyMap();
            try {
                if (sourceMapFile.exists()) {
                    readNames = SaveHook.loadSourceMapFromFile(str_clData_classes, sourceMapFile);
                }
            }
            catch (IOException e) {
                ErrorReporter.reportError((String)("Error loading source map from " + sourceMapFile.getPath()), (Throwable)e);
            }
            try {
                SaveHook.doSaveSourceMap(readNames, sourceMapFile, str_clData_classes);
            }
            catch (IOException e) {
                ErrorReporter.reportError((String)("Error writing source map " + sourceMapFile.getPath()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadSourceMapFromFile(Map classes, File mySourceMapFile) throws IOException {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(mySourceMapFile));
            int classNumber = CoverageIOUtil.readINT((DataInput)((Object)in));
            HashMap<String, String> readNames = new HashMap<String, String>(classNumber);
            for (int i = 0; i < classNumber; ++i) {
                String className = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                String classSource = CoverageIOUtil.readUTFFast((DataInput)((Object)in));
                if ("".equals(classSource)) continue;
                ClassData data = (ClassData)classes.get(className);
                if (data == null) {
                    readNames.put(className, classSource);
                    continue;
                }
                if (data.getSource() != null && data.getSource().equals(classSource)) continue;
                readNames.put(className, classSource);
            }
            HashMap<String, String> hashMap = readNames;
            return hashMap;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static void saveData(DataOutputStream os, final TObjectIntHashMap dict, Map classes) throws IOException {
        Iterator it = classes.values().iterator();
        while (it.hasNext()) {
            ((ClassData)it.next()).save(os, new DictionaryLookup(){

                public int getDictionaryIndex(String className) {
                    return dict.containsKey((Object)className) ? dict.get((Object)className) : -1;
                }
            });
        }
    }

    private static void saveDictionary(DataOutputStream os, TObjectIntHashMap dict, Map classes) throws IOException {
        int i = 0;
        Iterator it = classes.keySet().iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            dict.put((Object)className, i++);
            CoverageIOUtil.writeUTF((DataOutput)os, (String)className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveSourceMap(Map str_str_readNames, File sourceMapFile, Map str_clData_classes) throws IOException {
        HashMap<String, String> str_str_merged_map = new HashMap<String, String>(str_str_readNames);
        Iterator clData_it = str_clData_classes.values().iterator();
        while (clData_it.hasNext()) {
            ClassData classData = (ClassData)clData_it.next();
            if (str_str_merged_map.containsKey(classData.getName())) continue;
            str_str_merged_map.put(classData.getName(), classData.getSource());
        }
        DataOutputStream out = null;
        try {
            out = CoverageIOUtil.openFile((File)sourceMapFile);
            CoverageIOUtil.writeINT((DataOutput)out, (int)str_str_merged_map.size());
            Iterator entry_it = str_str_merged_map.entrySet().iterator();
            while (entry_it.hasNext()) {
                Map.Entry str_str_entry = entry_it.next();
                CoverageIOUtil.writeUTF((DataOutput)out, (String)((String)str_str_entry.getKey()));
                String value = (String)str_str_entry.getValue();
                CoverageIOUtil.writeUTF((DataOutput)out, (String)(value != null ? value : ""));
            }
        }
        finally {
            if (out != null) {
                CoverageIOUtil.close((DataOutputStream)out);
            }
        }
    }

    private void appendUnloaded(ProjectData projectData) {
        Collection matchedClasses = this.myClassFinder.findMatchedClasses();
        Iterator matchedClassIterator = matchedClasses.iterator();
        while (matchedClassIterator.hasNext()) {
            ClassEntry classEntry = (ClassEntry)matchedClassIterator.next();
            ClassData cd = projectData.getClassData(classEntry.getClassName());
            if (cd != null) continue;
            try {
                ClassReader reader = new ClassReader(classEntry.getClassInputStream());
                if (this.mySourceMapFile != null && cd == null) {
                    cd = projectData.getOrCreateClassData(classEntry.getClassName());
                }
                SourceLineCounter slc = new SourceLineCounter(cd, !projectData.isSampling(), (ProjectData)(this.mySourceMapFile != null ? projectData : null));
                reader.accept((ClassVisitor)slc, 0);
                if (slc.getNSourceLines() <= 0) continue;
                final TIntObjectHashMap lines = new TIntObjectHashMap(4, 0.99f);
                final int[] maxLine = new int[]{1};
                final ClassData classData = projectData.getOrCreateClassData(StringsPool.getFromPool(classEntry.getClassName()));
                slc.getSourceLines().forEachEntry(new TIntObjectProcedure(){

                    public boolean execute(int line, Object methodSig) {
                        LineData ld = new LineData(line, StringsPool.getFromPool((String)methodSig));
                        lines.put(line, (Object)ld);
                        if (line > maxLine[0]) {
                            maxLine[0] = line;
                        }
                        classData.registerMethodSignature(ld);
                        ld.setStatus((byte)0);
                        return true;
                    }
                });
                classData.setLines(LinesUtil.calcLineArray(maxLine[0], lines));
            }
            catch (Throwable e) {
                e.printStackTrace();
                ErrorReporter.reportError((String)("Failed to process class: " + classEntry.getClassName() + ", error: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void setSourceMapFile(File sourceMapFile) {
        this.mySourceMapFile = sourceMapFile;
    }
}

