/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.actions.GenerateSpringBeanDependenciesActionHandler;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.SpringBean;
import icons.SpringApiIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GenerateSpringBeanDependencyAction
extends BaseGenerateAction {
    public GenerateSpringBeanDependencyAction(CodeInsightActionHandler handler, String text) {
        super(handler);
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(SpringApiIcons.Spring);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(2);
        }
        if (!super.isValidForFile(project, editor, file)) {
            return false;
        }
        PsiClass psiClass = this.getTargetClass(editor, file);
        if (psiClass == null || psiClass.isInterface() || psiClass.isEnum() || psiClass.getQualifiedName() == null) {
            return false;
        }
        Module module = GenerateSpringBeanDependenciesUtil.getSpringModule(psiClass);
        return module != null && this.checkContext(module, psiClass);
    }

    protected boolean checkContext(@NotNull Module module, @NotNull PsiClass psiClass) {
        if (module == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(4);
        }
        if (this.isXmlBasedAction()) {
            SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            List beans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)psiClass));
            if (beans.isEmpty()) {
                for (PsiFile file : model.getConfigFiles()) {
                    if (!(file instanceof XmlFile)) continue;
                    return true;
                }
            } else {
                for (SpringBeanPointer bean : beans) {
                    if (!(bean.getSpringBean() instanceof SpringBean)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isXmlBasedAction() {
        return true;
    }

    protected boolean acceptPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GenerateSpringBeanDependencyAction.$$$reportNull$$$0(5);
        }
        return GenerateSpringBeanDependenciesUtil.acceptPsiClass(psiClass, this.isSetterDependency());
    }

    private boolean isSetterDependency() {
        return ((GenerateSpringBeanDependenciesActionHandler)this.getHandler()).isSetterDependency();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/actions/GenerateSpringBeanDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

