/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.maven.GwtCodehausFacetImporter;
import com.intellij.gwt.maven.GwtFacetImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import java.util.Collections;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;

public class GwtLtgtFacetImporter
extends GwtFacetImporter {
    public GwtLtgtFacetImporter() {
        super("net.ltgt.gwt.maven", "gwt-maven-plugin");
    }

    @Override
    protected void setupGwtSdk(GwtFacet facet, MavenProject project) {
        GwtFacetImporter.GwtPath path = this.resolveGwtPath(project);
        if (path == null) {
            return;
        }
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)facet.getConfiguration();
        configuration.setGwtSdkUrl(VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path.path)));
        configuration.setGwtSdkType(path.isInstalled ? null : "maven");
    }

    @Override
    protected void setupGwtCompilerOptions(GwtFacetConfiguration configuration, Module module, MavenProject project) {
        configuration.setCompilerParameters(this.getCompilerParameters(project));
        configuration.setOutputStyle(GwtJavaScriptOutputStyle.byId((String)this.findConfigValue(project, "style")));
        this.configureAdditionalCompilerVmParameters(configuration, project);
        String moduleName = this.findConfigValue(project, "moduleName");
        if (StringUtil.isNotEmpty((String)moduleName)) {
            GwtLtgtFacetImporter.setEnabledGwtModulesDumbAware(module, Collections.singleton(moduleName), configuration);
        }
    }

    @NotNull
    private String getCompilerParameters(MavenProject project) {
        String sourceLevel;
        String optimize;
        String localWorkers;
        String logLevel;
        ParametersList compilerParameters = new ParametersList();
        Element compilerArgs = this.getConfig(project, "compilerArgs");
        if (compilerArgs != null) {
            for (Element compilerArg : compilerArgs.getChildren("compilerArg")) {
                compilerParameters.add(compilerArg.getText());
            }
        }
        if ("true".equals(this.findConfigValue(project, "draftCompile"))) {
            compilerParameters.add("-draftCompile");
        }
        if ("true".equals(this.findConfigValue(project, "failOnError"))) {
            compilerParameters.add("-failOnError");
        }
        if (StringUtil.isNotEmpty((String)(logLevel = this.findConfigValue(project, "logLevel")))) {
            compilerParameters.add("-logLevel");
            compilerParameters.add(logLevel);
        }
        if (StringUtil.isNotEmpty((String)(localWorkers = this.findConfigValue(project, "localWorkers")))) {
            compilerParameters.add("-localWorkers");
            compilerParameters.add(localWorkers);
        }
        if (StringUtil.isNotEmpty((String)(optimize = this.findConfigValue(project, "optimize")))) {
            compilerParameters.add("-optimize");
            compilerParameters.add(optimize);
        }
        if (StringUtil.isNotEmpty((String)(sourceLevel = this.findConfigValue(project, "sourceLevel")))) {
            compilerParameters.add("-sourceLevel");
            compilerParameters.add(sourceLevel);
        }
        String string = compilerParameters.getParametersString();
        if (string == null) {
            GwtLtgtFacetImporter.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void configureAdditionalCompilerVmParameters(GwtFacetConfiguration configuration, MavenProject project) {
        Element systemProperties;
        ParametersList additionalVmParameters = new ParametersList();
        Element jvmArgs = this.getConfig(project, "jvmArgs");
        if (jvmArgs != null) {
            for (Element jvmArg : jvmArgs.getChildren("jvmArg")) {
                String jvmArgText = jvmArg.getText();
                if (jvmArgText.startsWith("-Xmx")) {
                    configuration.setCompilerMaxHeapSize(GwtCodehausFacetImporter.getSizeInMegabytes(jvmArgText));
                    continue;
                }
                additionalVmParameters.add(jvmArgText);
            }
        }
        if ((systemProperties = this.getConfig(project, "systemProperties")) != null) {
            for (Element systemProperty : systemProperties.getChildren()) {
                additionalVmParameters.add("-D" + systemProperty.getName() + "=" + systemProperty.getText());
            }
        }
        configuration.setAdditionalCompilerVMParameters(additionalVmParameters.getParametersString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/maven/GwtLtgtFacetImporter", "getCompilerParameters"));
    }
}

