/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtHtmlElementClassesFinder {
    @NonNls
    private static final String TAG_NAME_ANNOTATION = "com.google.gwt.dom.client.TagName";
    private static final Key<CachedValue<Map<String, String>>> TAG_TO_CLASS_MAP_KEY = Key.create((String)"GWT_TAG_TO_CLASS_NAME_MAP");

    private GwtHtmlElementClassesFinder() {
    }

    @Nullable
    public static String findElementClass(@NotNull String tagName, @NotNull Module module) {
        CachedValuesManager cachedValuesManager;
        Map map;
        if (tagName == null) {
            GwtHtmlElementClassesFinder.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GwtHtmlElementClassesFinder.$$$reportNull$$$0(1);
        }
        return (map = (Map)(cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject())).getCachedValue((UserDataHolder)module, TAG_TO_CLASS_MAP_KEY, (CachedValueProvider)new TagToClassMapCachedValueProvider(module), false)) != null ? (String)map.get(tagName) : null;
    }

    @NotNull
    public static List<String> getTagNames(@NotNull PsiClass elementClass) {
        PsiAnnotationMemberValue memberValue;
        PsiAnnotation annotation;
        PsiModifierList modifiers;
        if (elementClass == null) {
            GwtHtmlElementClassesFinder.$$$reportNull$$$0(2);
        }
        if ((modifiers = elementClass.getModifierList()) != null && (annotation = modifiers.findAnnotation(TAG_NAME_ANNOTATION)) != null && (memberValue = annotation.findAttributeValue("value")) instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)memberValue).getInitializers();
            SmartList result = new SmartList();
            for (PsiAnnotationMemberValue initializer : initializers) {
                String tag = (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)initializer, String.class);
                if (tag == null) continue;
                result.add(tag);
            }
            SmartList smartList = result;
            if (smartList == null) {
                GwtHtmlElementClassesFinder.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GwtHtmlElementClassesFinder.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTagNames";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TagToClassMapCachedValueProvider
    implements CachedValueProvider<Map<String, String>> {
        private final Module myModule;

        public TagToClassMapCachedValueProvider(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<Map<String, String>> compute() {
            HashMap result = new HashMap();
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findClass(GwtHtmlElementClassesFinder.TAG_NAME_ANNOTATION, scope);
            if (annotationClass != null) {
                AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope).forEach(psiClass -> {
                    for (String tagName : GwtHtmlElementClassesFinder.getTagNames(psiClass)) {
                        result.put(tagName, psiClass.getQualifiedName());
                    }
                    return true;
                });
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }
    }
}

