/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import org.gradle.api.Action;
import org.gradle.initialization.ReportedException;
import org.gradle.launcher.bootstrap.ExecutionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionReportingAction
implements Action<ExecutionListener> {
    private final Action<ExecutionListener> action;
    private final Action<Throwable> reporter;

    public ExceptionReportingAction(Action<ExecutionListener> action, Action<Throwable> reporter) {
        this.action = action;
        this.reporter = reporter;
    }

    @Override
    public void execute(ExecutionListener executionListener) {
        try {
            this.action.execute(executionListener);
        }
        catch (ReportedException e) {
            executionListener.onFailure(e.getCause());
        }
        catch (Throwable t) {
            this.reporter.execute(t);
            executionListener.onFailure(t);
        }
    }
}

