/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Consumer;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.psi.AngularJSRecursiveVisitor;
import org.angularjs.lang.psi.AngularJSRepeatExpression;
import org.jetbrains.annotations.NotNull;

public class AngularJSProcessor {
    private static final Map<String, String> NG_REPEAT_IMPLICITS = new HashMap<String, String>();
    public static final String $EVENT = "$event";

    public static void process(PsiElement element, Consumer<JSPsiElementBase> consumer) {
        PsiElement original = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)(original != element ? original : element.getContainingFile().getOriginalFile()));
        if (!(hostFile instanceof XmlFile)) {
            hostFile = original.getContainingFile();
        }
        if (!(hostFile instanceof XmlFile)) {
            return;
        }
        XmlFile file = (XmlFile)hostFile;
        Collection cache = (Collection)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            ArrayList<JSPsiElementBase> result = new ArrayList<JSPsiElementBase>();
            AngularJSProcessor.processDocument(file.getDocument(), result);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        for (JSPsiElementBase namedElement : cache) {
            if (!AngularJSProcessor.scopeMatches(original, (PsiElement)namedElement)) continue;
            consumer.consume((Object)namedElement);
        }
    }

    private static void processDocument(XmlDocument document, final Collection<JSPsiElementBase> result) {
        if (document == null) {
            return;
        }
        final AngularInjectedFilesVisitor visitor = new AngularInjectedFilesVisitor(result);
        for (XmlTag tag : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)document, XmlTag.class)) {
            new XmlBackedJSClassImpl.InjectedScriptsVisitor(tag, null, true, true, (XmlBackedJSClass.InjectedFileVisitor)visitor, true){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof HtmlEmbeddedContentImpl) {
                        AngularJSProcessor.processDocument((XmlDocument)PsiTreeUtil.findChildOfType((PsiElement)element, XmlDocument.class), result);
                    }
                    if (element instanceof XmlAttribute) {
                        visitor.accept(element);
                    }
                    return super.execute(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/AngularJSProcessor$1", "execute"));
                }
            }.go();
        }
    }

    private static boolean scopeMatches(PsiElement element, PsiElement declaration) {
        InjectedLanguageManager injector = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (declaration instanceof JSImplicitElement) {
            if ($EVENT.equals(((JSImplicitElement)declaration).getName())) {
                return AngularJSProcessor.eventScopeMatches(injector, element, declaration.getParent());
            }
            declaration = declaration.getParent();
        }
        PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
        XmlTagChild elementTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementContainer, (Class[])new Class[]{XmlTag.class, XmlText.class});
        PsiLanguageInjectionHost declarationContainer = injector.getInjectionHost(declaration);
        XmlTagChild declarationTag = (XmlTagChild)PsiTreeUtil.getNonStrictParentOfType((PsiElement)declarationContainer, (Class[])new Class[]{XmlTag.class, XmlText.class});
        if (declarationContainer != null && elementContainer != null && elementTag != null && declarationTag != null) {
            return PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)declarationTag, (PsiElement)elementTag, (boolean)false) && declarationContainer.getTextOffset() < elementContainer.getTextOffset() || AngularJSProcessor.isInRepeatStartEnd(declarationTag, declarationContainer, elementContainer);
        }
        return true;
    }

    private static boolean isInRepeatStartEnd(XmlTagChild declarationTag, PsiLanguageInjectionHost declarationContainer, PsiLanguageInjectionHost elementContainer) {
        PsiElement parent = declarationContainer.getParent();
        if (parent instanceof XmlAttribute && "ng-repeat-start".equals(((XmlAttribute)parent).getName())) {
            for (XmlTagChild next = declarationTag.getNextSiblingInTag(); next != null; next = next.getNextSiblingInTag()) {
                if (PsiTreeUtil.isAncestor((PsiElement)next, (PsiElement)elementContainer, (boolean)true)) {
                    return true;
                }
                if (next instanceof XmlTag && ((XmlTag)next).getAttribute("ng-repeat-end") != null) break;
            }
        }
        return false;
    }

    private static boolean eventScopeMatches(InjectedLanguageManager injector, PsiElement element, PsiElement parent) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{XmlAttribute.class});
        if (attribute == null) {
            PsiLanguageInjectionHost elementContainer = injector.getInjectionHost(element);
            attribute = (XmlAttribute)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementContainer, (Class[])new Class[]{XmlAttribute.class});
        }
        return attribute != null && CompletionUtil.getOriginalOrSelf((PsiElement)attribute) == CompletionUtil.getOriginalOrSelf((PsiElement)parent);
    }

    public static JSImplicitElementImpl.Builder createVariable(HtmlTag tag, XmlAttribute attribute, String name) {
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(name.substring(1), (PsiElement)attribute).setType(JSImplicitElement.Type.Variable);
        String tagName = tag.getName();
        if (HtmlDescriptorsTable.getTagDescriptor((String)tagName) != null) {
            elementBuilder.setTypeString("HTML" + StringUtil.capitalize((String)tagName) + "Element");
        }
        return elementBuilder;
    }

    static {
        NG_REPEAT_IMPLICITS.put("$index", "Number");
        NG_REPEAT_IMPLICITS.put("$first", "Boolean");
        NG_REPEAT_IMPLICITS.put("$middle", "Boolean");
        NG_REPEAT_IMPLICITS.put("$last", "Boolean");
        NG_REPEAT_IMPLICITS.put("$even", "Boolean");
        NG_REPEAT_IMPLICITS.put("$odd", "Boolean");
    }

    private static class AngularInjectedFilesVisitor
    extends JSResolveUtil.JSInjectedFilesVisitor {
        private final Collection<JSPsiElementBase> myResult;

        public AngularInjectedFilesVisitor(Collection<JSPsiElementBase> result) {
            this.myResult = result;
        }

        protected void process(JSFile file) {
            this.accept((PsiElement)file);
        }

        protected void accept(PsiElement element) {
            element.accept((PsiElementVisitor)new AngularJSRecursiveVisitor(){

                public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                    myResult.add(node);
                    super.visitJSDefinitionExpression(node);
                }

                public void visitJSVariable(JSVariable node) {
                    myResult.add(node);
                    super.visitJSVariable(node);
                }

                @Override
                public void visitAngularJSRepeatExpression(AngularJSRepeatExpression repeatExpression) {
                    if (repeatExpression.getNode().getElementType() == AngularJSElementTypes.REPEAT_EXPRESSION) {
                        for (Map.Entry entry : NG_REPEAT_IMPLICITS.entrySet()) {
                            myResult.add(new JSLocalImplicitElementImpl((String)entry.getKey(), (String)entry.getValue(), (PsiElement)repeatExpression));
                        }
                    }
                    super.visitAngularJSRepeatExpression(repeatExpression);
                }
            });
            if (element instanceof XmlAttribute) {
                JSImplicitElementImpl.Builder builder;
                String name = ((XmlAttribute)element).getName();
                if (AngularAttributesRegistry.isVariableAttribute(name, element.getProject())) {
                    builder = AngularJSProcessor.createVariable((HtmlTag)element.getParent(), (XmlAttribute)element, name);
                    this.myResult.add((JSPsiElementBase)builder.toImplicitElement());
                }
                if (AngularAttributesRegistry.isEventAttribute(name, element.getProject())) {
                    builder = new JSImplicitElementImpl.Builder(AngularJSProcessor.$EVENT, element).setType(JSImplicitElement.Type.Variable);
                    this.myResult.add((JSPsiElementBase)builder.toImplicitElement());
                }
            }
        }
    }
}

