/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.revision;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.DeletedState;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.revision.TFSContentStore;
import org.jetbrains.tfsIntegration.core.revision.TFSContentStoreFactory;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public abstract class TFSContentRevision
implements ByteBackedContentRevision {
    private final Project myProject;
    private final ServerInfo myServer;
    @Nullable
    private byte[] myContent;

    protected TFSContentRevision(Project project, ServerInfo server) {
        this.myProject = project;
        this.myServer = server;
    }

    @Nullable
    protected abstract Item getItem() throws TfsException;

    protected abstract int getItemId() throws TfsException;

    protected abstract int getChangeset() throws TfsException;

    public static TFSContentRevision create(Project project, @NotNull WorkspaceInfo workspace, final int changeset, final int itemId) throws TfsException {
        FilePath localPath;
        Item item;
        if (workspace == null) {
            TFSContentRevision.$$$reportNull$$$0(0);
        }
        if ((item = workspace.getServer().getVCS().queryItemById(itemId, changeset, true, project, TFSBundle.message("loading.item", new Object[0]))) != null) {
            localPath = workspace.findLocalPathByServerPath(item.getItem(), item.getType() == ItemType.Folder, project);
            if (localPath == null) {
                throw new TfsException(TFSBundle.message("no.mapping.for.0", item.getItem()));
            }
        } else {
            localPath = null;
        }
        return new TFSContentRevision(project, workspace.getServer()){

            @Override
            @Nullable
            protected Item getItem() {
                return item;
            }

            @Override
            protected int getItemId() {
                return itemId;
            }

            @Override
            protected int getChangeset() throws TfsException {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = localPath;
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(changeset, itemId);
                if (tfsRevisionNumber == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tfsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/tfsIntegration/core/revision/TFSContentRevision$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static TFSContentRevision create(final Project project, final @NotNull WorkspaceInfo workspace, final @NotNull FilePath localPath, final int changeset, final int itemId) {
        if (workspace == null) {
            TFSContentRevision.$$$reportNull$$$0(1);
        }
        if (localPath == null) {
            TFSContentRevision.$$$reportNull$$$0(2);
        }
        return new TFSContentRevision(project, workspace.getServer()){

            @Override
            @Nullable
            protected Item getItem() throws TfsException {
                return workspace.getServer().getVCS().queryItemById(itemId, changeset, true, project, TFSBundle.message("loading.item", new Object[0]));
            }

            @Override
            protected int getItemId() {
                return itemId;
            }

            @Override
            protected int getChangeset() {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = localPath;
                if (filePath == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(changeset, itemId);
                if (tfsRevisionNumber == null) {
                    2.$$$reportNull$$$0(1);
                }
                return tfsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/tfsIntegration/core/revision/TFSContentRevision$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static TFSContentRevision create(final Project project, final @NotNull FilePath localPath, final int changeset) throws TfsException {
        Collection<WorkspaceInfo> workspaces;
        if (localPath == null) {
            TFSContentRevision.$$$reportNull$$$0(3);
        }
        if ((workspaces = Workstation.getInstance().findWorkspaces(localPath, false, project)).isEmpty()) {
            throw new OperationFailedException("Cannot find mapping for item " + localPath.getPresentableUrl());
        }
        final WorkspaceInfo workspace = workspaces.iterator().next();
        return new TFSContentRevision(project, workspace.getServer()){
            @Nullable
            private Item myItem;

            @Override
            @Nullable
            protected Item getItem() throws TfsException {
                if (this.myItem == null) {
                    this.myItem = workspace.getServer().getVCS().queryItem(workspace.getName(), workspace.getOwnerName(), VersionControlPath.toTfsRepresentation(localPath), new ChangesetVersionSpec(changeset), DeletedState.Any, true, project, TFSBundle.message("loading.item", new Object[0]));
                }
                return this.myItem;
            }

            @Override
            protected int getItemId() throws TfsException {
                Item item = this.getItem();
                return item != null ? item.getItemid() : Integer.MIN_VALUE;
            }

            @Override
            protected int getChangeset() throws TfsException {
                Item item = this.getItem();
                return item != null ? item.getCs() : Integer.MIN_VALUE;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(changeset);
                if (tfsRevisionNumber == null) {
                    3.$$$reportNull$$$0(0);
                }
                return tfsRevisionNumber;
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = localPath;
                if (filePath == null) {
                    3.$$$reportNull$$$0(1);
                }
                return filePath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/tfsIntegration/core/revision/TFSContentRevision$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public String getContent() throws VcsException {
        return new String(this.getContentAsBytes(), this.getFile().getCharset(this.myProject));
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myContent == null) {
            try {
                this.myContent = this.loadContent();
            }
            catch (TfsException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        return this.myContent;
    }

    @Nullable
    private byte[] loadContent() throws TfsException, IOException {
        int itemId = this.getItemId();
        int changeset = this.getChangeset();
        TFSContentStore store = TFSContentStoreFactory.find(this.myServer.getUri().toASCIIString(), itemId, changeset);
        if (store == null) {
            Item item = this.getItem();
            if (item == null) {
                return null;
            }
            if (item.getType() == ItemType.Folder) {
                String message = MessageFormat.format("''{0}'' refers to a folder", this.getFile().getPresentableUrl());
                throw new OperationFailedException(message);
            }
            final String downloadUrl = item.getDurl();
            TFSVcs.assertTrue(downloadUrl != null, "Item without download URL: " + item.getItem());
            store = TFSContentStoreFactory.create(this.myServer.getUri().toASCIIString(), itemId, changeset);
            final Ref exception = new Ref();
            store.saveContent(new TfsFileUtil.ContentWriter(){

                @Override
                public void write(OutputStream outputStream) {
                    try {
                        TFSContentRevision.this.myServer.getVCS().downloadItem(TFSContentRevision.this.myProject, downloadUrl, outputStream, TFSBundle.message("downloading.0", TFSContentRevision.this.getFile().getName()));
                    }
                    catch (TfsException e) {
                        exception.set((Object)e);
                    }
                }
            });
            if (!exception.isNull()) {
                throw (TfsException)exception.get();
            }
        }
        return store.loadContent();
    }

    @NonNls
    public String toString() {
        return "TFSContentRevision [file=" + this.getFile() + ", revision=" + ((TfsRevisionNumber)this.getRevisionNumber()).getValue() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "workspace";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "localPath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/tfsIntegration/core/revision/TFSContentRevision";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

