/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.util.containers.ContainerUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class WorkItemsCheckinParameters {
    @NotNull
    private List<WorkItem> myWorkItems;
    @NotNull
    private Map<WorkItem, CheckinWorkItemAction> myActions;
    @Nullable
    private List<WorkItemLinkInfo> myLinks;

    private WorkItemsCheckinParameters(@NotNull List<WorkItem> workItems, @NotNull Map<WorkItem, CheckinWorkItemAction> actions, @Nullable List<WorkItemLinkInfo> links) {
        if (workItems == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(0);
        }
        if (actions == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(1);
        }
        this.myWorkItems = workItems;
        this.myActions = actions;
        this.myLinks = links;
    }

    public WorkItemsCheckinParameters() {
        this(Collections.emptyList(), ContainerUtil.newHashMap(), null);
    }

    @Nullable
    public CheckinWorkItemAction getAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(2);
        }
        return this.myActions.get(workItem);
    }

    public void setAction(@NotNull WorkItem workItem, @NotNull CheckinWorkItemAction action) {
        if (workItem == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(3);
        }
        if (action == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(4);
        }
        this.myActions.put(workItem, action);
    }

    public void removeAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(5);
        }
        this.myActions.remove(workItem);
    }

    @NotNull
    public List<WorkItem> getWorkItems() {
        List<WorkItem> list = Collections.unmodifiableList(this.myWorkItems);
        if (list == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public List<WorkItemLinkInfo> getLinks() {
        return this.myLinks != null ? Collections.unmodifiableList(this.myLinks) : null;
    }

    @NotNull
    public WorkItemsCheckinParameters createCopy() {
        WorkItemsCheckinParameters workItemsCheckinParameters = new WorkItemsCheckinParameters(ContainerUtil.newArrayList(this.myWorkItems), ContainerUtil.newHashMap(this.myActions), this.getLinks());
        if (workItemsCheckinParameters == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(7);
        }
        return workItemsCheckinParameters;
    }

    public void update(@NotNull WorkItemsQueryResult queryResult) {
        if (queryResult == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(8);
        }
        this.myWorkItems = queryResult.getWorkItems();
        this.myLinks = queryResult.getLinks();
        this.myActions.clear();
    }

    public void update(@NotNull WorkItemsCheckinParameters parameters) {
        if (parameters == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(9);
        }
        this.myWorkItems = parameters.myWorkItems;
        this.myLinks = parameters.myLinks;
        this.myActions = parameters.myActions;
    }

    @NotNull
    public Map<WorkItem, CheckinWorkItemAction> getWorkItemsActions() {
        Map<WorkItem, CheckinWorkItemAction> map = Collections.unmodifiableMap(this.myActions);
        if (map == null) {
            WorkItemsCheckinParameters.$$$reportNull$$$0(10);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workItems";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/WorkItemsCheckinParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkItemsActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAction";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

