/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;

public class WorkingFolderInfo {
    @NotNull
    private FilePath myLocalPath;
    @NotNull
    private String myServerPath;
    @NotNull
    private Status myStatus;

    public WorkingFolderInfo(FilePath localPath) {
        this(Status.Active, localPath, "");
    }

    public WorkingFolderInfo(@NotNull Status status, @NotNull FilePath localPath, @NotNull String serverPath) {
        if (status == null) {
            WorkingFolderInfo.$$$reportNull$$$0(0);
        }
        if (localPath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(1);
        }
        if (serverPath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(2);
        }
        this.myStatus = status;
        this.myLocalPath = localPath;
        this.myServerPath = serverPath;
    }

    @NotNull
    public FilePath getLocalPath() {
        FilePath filePath = this.myLocalPath;
        if (filePath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(3);
        }
        return filePath;
    }

    @NotNull
    public String getServerPath() {
        String string = this.myServerPath;
        if (string == null) {
            WorkingFolderInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            WorkingFolderInfo.$$$reportNull$$$0(5);
        }
        return status;
    }

    public void setStatus(@NotNull Status status) {
        if (status == null) {
            WorkingFolderInfo.$$$reportNull$$$0(6);
        }
        this.myStatus = status;
    }

    public void setServerPath(@NotNull String serverPath) {
        if (serverPath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(7);
        }
        this.myServerPath = serverPath;
    }

    public void setLocalPath(@NotNull FilePath localPath) {
        if (localPath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(8);
        }
        this.myLocalPath = localPath;
    }

    public WorkingFolderInfo getCopy() {
        return new WorkingFolderInfo(this.myStatus, this.myLocalPath, this.myServerPath);
    }

    @Nullable
    String getServerPathByLocalPath(@NotNull FilePath localPath) {
        if (localPath == null) {
            WorkingFolderInfo.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmpty((String)this.getServerPath()) && localPath.isUnder(this.getLocalPath(), false)) {
            return VersionControlPath.getCombinedServerPath(this.getLocalPath(), this.getServerPath(), localPath);
        }
        return null;
    }

    @Nullable
    public FilePath getLocalPathByServerPath(String serverPath, boolean isDirectory) {
        if (!StringUtil.isEmpty((String)this.getServerPath()) && VersionControlPath.isUnder(this.getServerPath(), serverPath)) {
            return VersionControlPath.getCombinedLocalPath(this.getLocalPath(), this.getServerPath(), serverPath, isDirectory);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/WorkingFolderInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setServerPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLocalPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getServerPathByLocalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Status {
        Active,
        Cloaked;

    }
}

