/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.ElementPresentationManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsApplicationComponent
implements ApplicationComponent {
    public void initComponent() {
        ElementPresentationManager.registerNameProvider((Function)((NullableFunction)o -> {
            if (o instanceof Result) {
                String resultName = ((Result)o).getName().getStringValue();
                return resultName != null ? resultName : "success";
            }
            return null;
        }));
        StrutsApplicationComponent.registerDocumentationProviders();
    }

    private static void registerDocumentationProviders() {
        ElementPresentationManager.registerDocumentationProvider((Function)((NullableFunction)o -> {
            if (o instanceof Action) {
                Action action = (Action)o;
                StrutsPackage strutsPackage = action.getStrutsPackage();
                DocumentationBuilder builder = new DocumentationBuilder();
                PsiClass actionClass = action.searchActionClass();
                builder.addLine("Action", action.getName().getStringValue()).addLine("Class", actionClass != null ? actionClass.getQualifiedName() : null).addLine("Method", action.getMethod().getStringValue()).addLine("Package", strutsPackage.getName().getStringValue()).addLine("Namespace", strutsPackage.searchNamespace());
                return builder.getText();
            }
            if (o instanceof Result) {
                Result result = (Result)o;
                PathReference pathReference = (PathReference)result.getValue();
                String displayPath = pathReference != null ? pathReference.getPath() : "???";
                ResultType resultType = result.getEffectiveResultType();
                String resultTypeValue = resultType != null ? resultType.getName().getStringValue() : "???";
                DocumentationBuilder builder = new DocumentationBuilder();
                builder.addLine("Path", displayPath).addLine("Type", resultTypeValue);
                return builder.getText();
            }
            return null;
        }));
    }

    private static class DocumentationBuilder {
        @NonNls
        private final StringBuilder builder = new StringBuilder("<html><table>");

        private DocumentationBuilder() {
        }

        private DocumentationBuilder addLine(@NotNull @NonNls String label, @Nullable @NonNls String content) {
            if (label == null) {
                DocumentationBuilder.$$$reportNull$$$0(0);
            }
            this.builder.append("<tr><td><strong>").append(label).append(":</strong></td>").append("<td>").append(StringUtil.isNotEmpty((String)content) ? content : "-").append("</td></tr>");
            return this;
        }

        private String getText() {
            this.builder.append("</table></html>");
            return this.builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/struts2/StrutsApplicationComponent$DocumentationBuilder", "addLine"));
        }
    }
}

