/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.formatter.AbstractGspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspFormattingHelper;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspSpacingProcessor;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;

public class GspBlock
extends AbstractXmlBlock
implements AbstractGspBlock,
GspElementTypes {
    private static final Logger LOG = Logger.getInstance(GspBlock.class);
    private final Indent myIndent;
    private final TextRange myTextRange;
    private final GspFormattingHelper myFormattingHelper;

    public GspBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy);
        this.myTextRange = textRange != null ? textRange : super.getTextRange();
        this.myIndent = indent;
        this.myFormattingHelper = new GspFormattingHelper(this.myXmlFormattingPolicy, this.myNode, this.myTextRange);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            GspBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    protected List<Block> buildChildren() {
        if (this.myNode.getElementType() == GSP_DIRECTIVE_ATTRIBUTE_VALUE || this.myNode.getElementType() == JSP_STYLE_COMMENT || this.myNode.getElementType() == GSP_STYLE_COMMENT) {
            return EMPTY;
        }
        if (this.myNode.getFirstChildNode() == null) {
            return EMPTY;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        Wrap attrWrap = Wrap.createWrap((WrapType)GspBlock.getWrapType((int)this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Alignment attrAlignment = Alignment.createAlignment();
        ASTNode child = this.myNode.getFirstChildNode();
        while (child != null) {
            Alignment alignment;
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) || child.getTextLength() == 0) {
                child = child.getTreeNext();
                continue;
            }
            IElementType elementType = child.getElementType();
            Object wrap = elementType == GspElementTypes.GRAILS_TAG_ATTRIBUTE ? attrWrap : null;
            if ((child = this.myFormattingHelper.processChild((List<Block>)result2, child, (Wrap)wrap, alignment = elementType == GspElementTypes.GRAILS_TAG_ATTRIBUTE && this.myXmlFormattingPolicy.getShouldAlignAttributes() ? attrAlignment : null, Indent.getNoneIndent())) == null) continue;
            LOG.assertTrue(child.getTreeParent() == this.myNode);
        }
        return result2;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            GspBlock.$$$reportNull$$$0(1);
        }
        if (child1 instanceof AbstractGspBlock && child2 instanceof AbstractGspBlock) {
            return GspSpacingProcessor.getSpacing(this.myXmlFormattingPolicy, (AbstractGspBlock)child1, (AbstractGspBlock)child2);
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof GspXmlRootTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                GspBlock.$$$reportNull$$$0(2);
            }
            return childAttributes;
        }
        if (psiParent instanceof GspTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                GspBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            GspBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return false;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean isIncomplete() {
        return this.isIncomplete(this.myNode);
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        ASTNode lastChild;
        if (node == null) {
            GspBlock.$$$reportNull$$$0(5);
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild != null && (lastChild.getPsi() instanceof PsiErrorElement || this.isIncomplete(lastChild));
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

