/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.SpringDiagramNode;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveBeanDiagramDataModel
extends DiagramDataModel<SpringElementWrapper> {
    private final LiveBean myLiveBean;
    private final LiveBeansPanel.LiveBeanContext myBeanContext;
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = ContainerUtil.newLinkedHashSet();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = ContainerUtil.newLinkedHashSet();
    private final Collection<SpringElementWrapper> myRemovedNodes = ContainerUtil.newLinkedHashSet();

    LiveBeanDiagramDataModel(DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider, LiveBean liveBean, LiveBeansPanel.LiveBeanContext beanContext) {
        super(beanContext.project, springBaseBeanPointerDiagramProvider);
        this.myLiveBean = liveBean;
        this.myBeanContext = beanContext;
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getOrCreateElement(LiveBean liveBean, CommonSpringModel springModel) {
        DiagramNode<SpringElementWrapper> target = this.getNode(liveBean);
        if (target == null) {
            target = this.addNode(liveBean, springModel);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(LiveBean liveBean, CommonSpringModel springModel) {
        return liveBean == null ? null : this.addNode(new LiveBeanWrapper(liveBean, this.myBeanContext, springModel));
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper wrapper) {
        if (this.myRemovedNodes.contains(wrapper)) {
            return null;
        }
        SpringDiagramNode node = new SpringDiagramNode(wrapper, this.getProvider());
        if (!this.myNodes.contains(node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper wrapper) {
        return this.addNode(wrapper);
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    private void updateDataModel() {
        CommonSpringModel springModel = (CommonSpringModel)this.myBeanContext.modelFactory.create();
        DiagramNode<SpringElementWrapper> node = this.getOrCreateElement(this.myLiveBean, springModel);
        for (LiveBean dependency : this.myLiveBean.getDependencies()) {
            DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(dependency, springModel);
            this.addEdge(node, targetNode, SpringDependencyType.UNKNOWN);
        }
        for (LiveBean injectedInto : this.myLiveBean.getInjectedInto()) {
            DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(injectedInto, springModel);
            this.addEdge(sourceNode, node, SpringDependencyType.UNKNOWN);
        }
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info) {
        if (info == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(3);
        }
        if (source != null && target != null) {
            this.addEdge(new SpringDiagramEdge(source, target, info));
        }
    }

    private void addEdge(SpringDiagramEdge edge) {
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add((DiagramEdge<SpringElementWrapper>)edge);
        }
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getJavaStructureModificationCount();
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull LiveBean bean) {
        if (bean == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(4);
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        LiveBeanDiagramDataModel liveBeanDiagramDataModel = this;
        if (liveBeanDiagramDataModel == null) {
            LiveBeanDiagramDataModel.$$$reportNull$$$0(5);
        }
        return liveBeanDiagramDataModel;
    }

    public void dispose() {
    }

    public void removeNode(DiagramNode<SpringElementWrapper> node) {
        this.myRemovedNodes.add((SpringElementWrapper)node.getIdentifyingElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/diagram/LiveBeanDiagramDataModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

