/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.beans.LiveBeansModel;
import com.intellij.spring.boot.run.lifecycle.beans.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.LiveResource;
import com.intellij.spring.boot.run.lifecycle.tabs.LifecycleFinderRecursivePanel;
import com.intellij.spring.boot.run.lifecycle.tabs.LiveBeansPanel;
import com.intellij.ui.FinderRecursivePanel;
import icons.SpringApiIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourcesPanel
extends LifecycleFinderRecursivePanel<LiveResourceItem> {
    private static final String LIVE_RESOURCES_PANEL_GROUP_ID = "LiveResourcesPanel";
    private final LiveContext myContext;

    LiveResourcesPanel(@NotNull Project project, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler) {
        if (project == null) {
            LiveResourcesPanel.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            LiveResourcesPanel.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            LiveResourcesPanel.$$$reportNull$$$0(2);
        }
        this(project, null, LIVE_RESOURCES_PANEL_GROUP_ID, runConfiguration, processHandler, null);
    }

    LiveResourcesPanel(@NotNull Project project, @Nullable FinderRecursivePanel parent, @Nullable String groupId, @NotNull SpringBootApplicationRunConfiguration runConfiguration, @NotNull ProcessHandler processHandler, @Nullable LiveContext context) {
        if (project == null) {
            LiveResourcesPanel.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            LiveResourcesPanel.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            LiveResourcesPanel.$$$reportNull$$$0(5);
        }
        super(project, parent, groupId, runConfiguration, processHandler);
        this.myContext = context;
    }

    @NotNull
    protected List<LiveResourceItem> getListItems() {
        List resources;
        if (this.myContext != null) {
            resources = this.myContext.getResources();
        } else {
            LiveBeansModel model = this.getModel();
            if (model == null) {
                List<LiveResourceItem> list = Collections.emptyList();
                if (list == null) {
                    LiveResourcesPanel.$$$reportNull$$$0(6);
                }
                return list;
            }
            resources = model.getResources();
        }
        Collections.sort(resources, Comparator.comparing(LiveResource::getDisplayName, NaturalComparator.INSTANCE));
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.getRunConfiguration().getConfigurationModule()).getSearchScope();
        List<LiveResourceItem> list = resources.stream().map(resource -> new LiveResourceItem(this.getProject(), (LiveResource)resource, module, mainClass, searchScope)).collect(Collectors.toList());
        if (list == null) {
            LiveResourcesPanel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    protected String getItemText(LiveResourceItem item) {
        String string = item.getResource().getDisplayName();
        if (string == null) {
            LiveResourcesPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected boolean hasChildren(LiveResourceItem item) {
        return true;
    }

    @Nullable
    protected Icon getItemIcon(LiveResourceItem item) {
        Navigatable navigatable = item.getNavigatable();
        if (navigatable instanceof PsiFile) {
            return ((PsiFile)navigatable).getIcon(0);
        }
        Icon icon = item.getResource().getIcon();
        return icon == null ? SpringApiIcons.SpringJavaConfig : icon;
    }

    @Nullable
    protected JComponent createRightComponent(LiveResourceItem item) {
        return new LiveBeansPanel(this.getProject(), this, this.getGroupId(), this.getRunConfiguration(), this.getProcessHandler(), null, item.getResource());
    }

    @Nullable
    protected String getItemTooltipText(LiveResourceItem item) {
        if (item.getResource().hasDescription()) {
            return item.getResource().getDescription();
        }
        return item.getResource().getDisplayName();
    }

    @Nullable
    protected VirtualFile getContainingFile(LiveResourceItem item) {
        Navigatable navigatable = item.getNavigatable();
        if (!(navigatable instanceof PsiElement)) {
            return null;
        }
        PsiElement psiElement = (PsiElement)navigatable;
        if (psiElement.isValid() && psiElement.getContainingFile() != null) {
            return psiElement.getContainingFile().getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        LiveResourceItem selectedValue = (LiveResourceItem)this.getSelectedValue();
        if (selectedValue != null) {
            PsiElement psiElement;
            Navigatable navigatable = selectedValue.getNavigatable();
            if (CommonDataKeys.NAVIGATABLE.is(dataId) || CommonDataKeys.PSI_ELEMENT.is(dataId) && navigatable instanceof PsiElement) {
                return navigatable;
            }
            if (CommonDataKeys.PSI_FILE.is(dataId) && navigatable instanceof PsiElement && (psiElement = (PsiElement)navigatable).isValid()) {
                return psiElement.getContainingFile();
            }
        }
        return super.getData(dataId);
    }

    @Override
    protected boolean doUpdateItem(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(9);
        }
        SpringBootApplicationRunConfiguration runConfiguration = this.getRunConfiguration();
        Module module = runConfiguration.getModule();
        PsiClass mainClass = runConfiguration.getMainClass();
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)this.getRunConfiguration().getConfigurationModule()).getSearchScope();
        return item.updateItem(module, mainClass, searchScope);
    }

    @Override
    protected String getEditActionHintMessage(@NotNull LiveResourceItem item) {
        if (item == null) {
            LiveResourcesPanel.$$$reportNull$$$0(10);
        }
        return SpringBootRunBundle.message("spring.boot.application.endpoints.config.file.not.found", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEditActionHintMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LiveResourceItem {
        @NotNull
        private final Project myProject;
        @NotNull
        private final LiveResource myResource;
        @Nullable
        private Navigatable myNavigatable;

        LiveResourceItem(@NotNull Project project, @NotNull LiveResource resource, @Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            if (project == null) {
                LiveResourceItem.$$$reportNull$$$0(0);
            }
            if (resource == null) {
                LiveResourceItem.$$$reportNull$$$0(1);
            }
            if (searchScope == null) {
                LiveResourceItem.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myResource = resource;
            this.updateItem(module, mainClass, searchScope);
        }

        @NotNull
        public LiveResource getResource() {
            LiveResource liveResource = this.myResource;
            if (liveResource == null) {
                LiveResourceItem.$$$reportNull$$$0(3);
            }
            return liveResource;
        }

        @Nullable
        public Navigatable getNavigatable() {
            return DumbService.isDumb((Project)this.myProject) ? null : this.myNavigatable;
        }

        public boolean updateItem(@Nullable Module module, @Nullable PsiClass mainClass, @NotNull GlobalSearchScope searchScope) {
            Navigatable navigatable;
            if (searchScope == null) {
                LiveResourceItem.$$$reportNull$$$0(4);
            }
            boolean changed = !Comparing.equal((Object)this.myNavigatable, (Object)(navigatable = this.myResource.getResourceNavigatable(this.myProject, module, (PsiElement)mainClass, searchScope)));
            this.myNavigatable = navigatable;
            return changed;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LiveResourceItem) {
                return this.myResource.equals(((LiveResourceItem)obj).myResource);
            }
            return false;
        }

        public int hashCode() {
            return this.myResource.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/tabs/LiveResourcesPanel$LiveResourceItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateItem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

