/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.seam.model.xml.PageflowDomModelManager;
import com.intellij.seam.model.xml.PageflowModel;
import com.intellij.seam.model.xml.pageflow.Action;
import com.intellij.seam.model.xml.pageflow.Page;
import com.intellij.seam.model.xml.pageflow.PageflowDefinition;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowDefinitionActionConverter
extends ResolvingConverter<Action> {
    @NotNull
    public Collection<Action> getVariants(ConvertContext context) {
        String actionName;
        DomElement element = context.getInvocationElement();
        Action currentAction = (Action)element.getParentOfType(Action.class, false);
        List<Action> pageflowActions = PageflowDefinitionActionConverter.getPageflowActions(PageflowDefinitionActionConverter.getPageflowDefinition(context));
        if (currentAction != null && !StringUtil.isEmptyOrSpaces((String)(actionName = currentAction.getName().getStringValue()))) {
            ArrayList<Action> noCurrent = new ArrayList<Action>();
            for (Action pageflowAction : pageflowActions) {
                if (actionName.equals(pageflowAction.getName().getStringValue())) continue;
                noCurrent.add(pageflowAction);
            }
            ArrayList<Action> arrayList = noCurrent;
            if (arrayList == null) {
                PageflowDefinitionActionConverter.$$$reportNull$$$0(0);
            }
            return arrayList;
        }
        List<Action> list = pageflowActions;
        if (list == null) {
            PageflowDefinitionActionConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    public Action fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PageflowDefinition pageflowDefinition = PageflowDefinitionActionConverter.getPageflowDefinition(context);
        for (Action action : PageflowDefinitionActionConverter.getPageflowActions(pageflowDefinition)) {
            if (!s.equals(action.getName().getStringValue())) continue;
            return action;
        }
        return null;
    }

    @Nullable
    private static PageflowDefinition getPageflowDefinition(ConvertContext context) {
        PageflowModel model = PageflowDomModelManager.getInstance(context.getFile().getProject()).getPageflowModel(context.getFile());
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (PageflowDefinition)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    private static List<Action> getPageflowActions(@Nullable PageflowDefinition pageflowDefinition) {
        if (pageflowDefinition == null) {
            return Collections.emptyList();
        }
        ArrayList<Action> actions = new ArrayList<Action>(pageflowDefinition.getActions());
        for (Page page : pageflowDefinition.getPages()) {
            actions.addAll(page.getActions());
        }
        actions.addAll(pageflowDefinition.getStartPage().getActions());
        return actions;
    }

    public String toString(@Nullable Action pageflowNamedElement, ConvertContext context) {
        return pageflowNamedElement == null ? null : pageflowNamedElement.getName().getStringValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/xml/converters/PageflowDefinitionActionConverter", "getVariants"));
    }
}

