/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMBundleArtifactType;
import com.intellij.dmserver.artifacts.DMConfigArtifactType;
import com.intellij.dmserver.artifacts.DMParArtifactType;
import com.intellij.dmserver.artifacts.DMPlanArtifactType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WithModuleArtifactUtil {
    public static Artifact findDmBundleArtifactFor(@NotNull Module module) {
        if (module == null) {
            WithModuleArtifactUtil.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        ArrayList scope = new ArrayList();
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMBundleArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMParArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMPlanArtifactType.getInstance()));
        scope.addAll(manager.getArtifactsByType((ArtifactType)DMConfigArtifactType.getInstance()));
        for (Artifact nextArtifact : scope) {
            Module nextModule = WithModuleArtifactUtil.findModuleFor(project, nextArtifact);
            if (!module.equals(nextModule)) continue;
            return nextArtifact;
        }
        return null;
    }

    @NotNull
    public static List<Artifact> findWithModuleArtifactsFor(@NotNull Module module) {
        if (module == null) {
            WithModuleArtifactUtil.$$$reportNull$$$0(1);
        }
        Project project = module.getProject();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact next : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            Module nextModule = WithModuleArtifactUtil.findModuleFor(project, next);
            if (!module.equals(nextModule)) continue;
            result.add(next);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            WithModuleArtifactUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static List<Artifact> findWithModuleArtifactsFor(Project project, @NotNull String moduleName) {
        if (moduleName == null) {
            WithModuleArtifactUtil.$$$reportNull$$$0(3);
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact next : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            String nextModuleName = WithModuleArtifactUtil.findModuleNameFor(project, next);
            if (!moduleName.equals(nextModuleName)) continue;
            result.add(next);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            WithModuleArtifactUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private static String findModuleNameFor(Project project, Artifact artifact) {
        if (!(artifact.getArtifactType() instanceof DMArtifactTypeBase)) {
            return null;
        }
        DMArtifactTypeBase artifactType = (DMArtifactTypeBase)artifact.getArtifactType();
        ArrayList moduleNames = new ArrayList();
        Processor processor = element -> {
            String moduleName = element.getModuleName();
            if (moduleName != null) {
                moduleNames.add(moduleName);
            }
            return false;
        };
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        ArtifactUtil.processPackagingElements((Artifact)artifact, artifactType.getModulePackagingElementType(), (Processor)processor, (PackagingElementResolvingContext)context, (boolean)false);
        if (moduleNames.isEmpty()) {
            return null;
        }
        String theOneName = (String)moduleNames.get(0);
        return theOneName;
    }

    @Nullable
    public static Module findModuleFor(Project project, Artifact artifact) {
        String moduleName = WithModuleArtifactUtil.findModuleNameFor(project, artifact);
        return moduleName == null ? null : ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/artifacts/WithModuleArtifactUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/artifacts/WithModuleArtifactUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findWithModuleArtifactsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDmBundleArtifactFor";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findWithModuleArtifactsFor";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

