/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.integration.DMServerIntegrationDataNoRepository;
import com.intellij.dmserver.integration.DMServerIntegrationStateBase;
import com.intellij.dmserver.integration.DMServerRepositoryExternalItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryItem10;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerIntegrationData
implements ApplicationServerPersistentData {
    @NonNls
    private static final String STATE_ELEMENT = "integrationState";
    private DMServerIntegrationState myState;

    public DMServerIntegrationData(@NotNull String installationHome) {
        if (installationHome == null) {
            DMServerIntegrationData.$$$reportNull$$$0(0);
        }
        this.myState = new DMServerIntegrationState();
        this.setInstallationHome(installationHome);
    }

    @NotNull
    public String getInstallationHome() {
        String string = this.myState.getInstallationHome();
        if (string == null) {
            DMServerIntegrationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public DMServerInstallation getInstallation() {
        return DMServerInstallationManager.getInstance().findInstallation(this.myState.getInstallationHome());
    }

    public void setInstallationHome(@NotNull String installationHome) {
        if (installationHome == null) {
            DMServerIntegrationData.$$$reportNull$$$0(2);
        }
        this.myState.setInstallationHome(installationHome);
    }

    public int getShellPort() {
        return this.myState.getShellPort();
    }

    public void setShellPort(int shellPort) {
        this.myState.setShellPort(shellPort);
    }

    public boolean isShellEnabled() {
        return this.myState.isShellEnabled();
    }

    public void setShellEnabled(boolean shellEnabled) {
        this.myState.setShellEnabled(shellEnabled);
    }

    public int getDeploymentTimeoutSecs() {
        return this.myState.getDeploymentTimeoutSecs();
    }

    public void setDeploymentTimeoutSecs(int deploymentTimeoutSecs) {
        this.myState.setDeploymentTimeoutSecs(deploymentTimeoutSecs);
    }

    public String getPickupFolder() {
        return this.myState.getPickupFolder();
    }

    public void setPickupFolder(String pickupFolder) {
        this.myState.setPickupFolder(pickupFolder);
    }

    public String getDumpsFolder() {
        return this.myState.getDumpsFolder();
    }

    public void setDumpsFolder(String dumpsFolder) {
        this.myState.setDumpsFolder(dumpsFolder);
    }

    public boolean isWrapSystemErr() {
        return this.myState.isWrapSystemErr();
    }

    public void setWrapSystemErr(boolean wrapSystemErr) {
        this.myState.setWrapSystemErr(wrapSystemErr);
    }

    public boolean isWrapSystemOut() {
        return this.myState.isWrapSystemOut();
    }

    public void setWrapSystemOut(boolean wrapSystemOut) {
        this.myState.setWrapSystemOut(wrapSystemOut);
    }

    public List<DMServerRepositoryItem> getRepositoryItems() {
        return this.myState.getRepositoryItems();
    }

    public void setRepositoryItems(List<DMServerRepositoryItem> repositoryItems) {
        this.myState.setRepositoryItems(new ArrayList<DMServerRepositoryItem>(repositoryItems));
    }

    public boolean isReloadRequired() {
        return this.myState.isReloadRequired();
    }

    public void setReloadRequired(boolean reloadRequired) {
        this.myState.setReloadRequired(reloadRequired);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element content = element.getChild(STATE_ELEMENT);
        if (content == null) {
            DMServerIntegrationDataNoRepository noRepositoryData = new DMServerIntegrationDataNoRepository();
            noRepositoryData.readExternal(element);
            this.myState = new DMServerIntegrationState();
            this.myState.setInstallationHome(noRepositoryData.getInstallationHome());
            this.myState.setShellPort(noRepositoryData.getShellPort());
            this.myState.setShellEnabled(noRepositoryData.isShellEnabled());
            this.myState.setDeploymentTimeoutSecs(noRepositoryData.getDeploymentTimeoutSecs());
            this.myState.setDumpsFolder(noRepositoryData.getDumpsFolder());
            this.myState.setPickupFolder(noRepositoryData.getPickupFolder());
            this.myState.setWrapSystemErr(noRepositoryData.isWrapSystemErr());
            this.myState.setWrapSystemOut(noRepositoryData.isWrapSystemOut());
            this.myState.setReloadRequired(true);
        } else {
            this.myState = (DMServerIntegrationState)XmlSerializer.deserialize((Element)content, DMServerIntegrationState.class);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.addContent(XmlSerializer.serialize((Object)this.myState, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationHome";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/integration/DMServerIntegrationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/integration/DMServerIntegrationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInstallationHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="integrationState")
    public static class DMServerIntegrationState
    extends DMServerIntegrationStateBase {
        private boolean myReloadRequired = false;
        private List<DMServerRepositoryItem> myRepositoryItems = new ArrayList<DMServerRepositoryItem>();

        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTypes={DMServerRepositoryExternalItem.class, DMServerRepositoryWatchedItem.class, DMServerRepositoryItem10.class})
        public List<DMServerRepositoryItem> getRepositoryItems() {
            return this.myRepositoryItems;
        }

        public void setRepositoryItems(List<DMServerRepositoryItem> repositoryItems) {
            this.myRepositoryItems = repositoryItems;
        }

        public boolean isReloadRequired() {
            return this.myReloadRequired;
        }

        public void setReloadRequired(boolean reloadRequired) {
            this.myReloadRequired = reloadRequired;
        }
    }
}

