/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.osmorc;

import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class DMServerFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LocalFileSystem myFileSystem;

    public DMServerFrameworkInstanceManager(LocalFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
    }

    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            DMServerFrameworkInstanceManager.$$$reportNull$$$0(0);
        }
        if (type == null) {
            DMServerFrameworkInstanceManager.$$$reportNull$$$0(1);
        }
        List<SelectedBundle> list = Collections.emptyList();
        if (list == null) {
            DMServerFrameworkInstanceManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        String instanceName;
        if (frameworkInstanceDefinition == null) {
            DMServerFrameworkInstanceManager.$$$reportNull$$$0(3);
        }
        if ((instanceName = frameworkInstanceDefinition.getName()) == null || instanceName.trim().length() == 0) {
            return DmServerBundle.message("DMServerFrameworkInstanceManager.error.instance.name.required", new Object[0]);
        }
        VirtualFile serverRootFolder = this.myFileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (serverRootFolder == null || !serverRootFolder.isDirectory()) {
            return DmServerBundle.message("DMServerFrameworkInstanceManager.error.folder.not.exists.or.not.folder", frameworkInstanceDefinition.getBaseFolder());
        }
        ValidationResult installationValid = new DMServerInstallationImpl(serverRootFolder).validate();
        if (!installationValid.isOk()) {
            return installationValid.getErrorMessage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkInstanceDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dmserver/osmorc/DMServerFrameworkInstanceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkBundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkBundles";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkValidity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

