/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.regex.Pattern;
import kotlin.jvm.functions.Function2;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        return new JvmClassName(internalName);
    }

    @NotNull
    public static JvmClassName byClassId(@NotNull ClassId classId) {
        return JvmClassName.byClassId(classId, null);
    }

    @NotNull
    public static JvmClassName byClassId(@NotNull ClassId classId, @Nullable TypeMappingConfiguration<?> typeMappingConfiguration) {
        String relativeClassName;
        FqName packageFqName = classId.getPackageFqName();
        String[] relativeClassNameSegments = classId.getRelativeClassName().asString().split(Pattern.quote("."));
        if (relativeClassNameSegments.length == 1) {
            relativeClassName = relativeClassNameSegments[0];
        } else if (relativeClassNameSegments.length > 1 && typeMappingConfiguration != null) {
            Function2<String, String, String> innerClassNameFactory = typeMappingConfiguration.getInnerClassNameFactory();
            relativeClassName = (String)innerClassNameFactory.invoke((Object)relativeClassNameSegments[0], (Object)relativeClassNameSegments[1]);
            for (int i = 2; i < relativeClassNameSegments.length; ++i) {
                relativeClassName = (String)innerClassNameFactory.invoke((Object)relativeClassName, (Object)relativeClassNameSegments[i]);
            }
        } else {
            relativeClassName = classId.getRelativeClassName().asString().replace('.', '$');
        }
        return packageFqName.isRoot() ? new JvmClassName(relativeClassName) : new JvmClassName(packageFqName.asString().replace('.', '/') + "/" + relativeClassName);
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        JvmClassName r = new JvmClassName(fqName2.asString().replace('.', '/'));
        r.fqName = fqName2;
        return r;
    }

    private JvmClassName(@NotNull String internalName) {
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqNameForTopLevelClassMaybeWithDollars() {
        return new FqName(this.internalName.replace('/', '.'));
    }

    @NotNull
    public FqName getPackageFqName() {
        int lastSlash = this.internalName.lastIndexOf("/");
        if (lastSlash == -1) {
            return FqName.ROOT;
        }
        return new FqName(this.internalName.substring(0, lastSlash).replace('/', '.'));
    }

    @NotNull
    public String getInternalName() {
        return this.internalName;
    }

    public String toString() {
        return this.internalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.internalName.equals(((JvmClassName)o).internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

