/*
 * Decompiled with CFR 0.152.
 */
package aQute.p2.provider;

import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.p2.api.Artifact;
import aQute.p2.api.P2Index;
import aQute.p2.provider.ArtifactRepository;
import aQute.p2.provider.CompositeArtifacts;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

public class P2Impl {
    private static final Logger logger = LoggerFactory.getLogger(P2Impl.class);
    private final HttpClient client;
    private final URI base;
    private static final Promise<List<Artifact>> RESOLVED = Promises.resolved(Collections.emptyList());
    private final Set<URI> defaults = Collections.newSetFromMap(new ConcurrentHashMap());
    private Executor executor;

    public P2Impl(HttpClient c, URI base, Executor executor) throws Exception {
        this.client = c;
        this.executor = executor;
        this.base = this.normalize(base);
    }

    private URI normalize(URI base) throws Exception {
        String path = base.getPath();
        if (path.endsWith("/")) {
            return base;
        }
        return new URI(base.toString() + "/");
    }

    public List<Artifact> getArtifacts() throws Exception {
        Set<URI> cycles = Collections.newSetFromMap(new ConcurrentHashMap());
        return (List)this.getArtifacts(cycles, this.base).getValue();
    }

    private Promise<List<Artifact>> getArtifacts(Set<URI> cycles, URI uri) {
        if (!cycles.add(uri)) {
            return Promises.failed((Throwable)new IllegalStateException("There is a cycle in the p2 setup : " + cycles + " -> " + uri));
        }
        try {
            String type = uri.getPath();
            if (type.endsWith("/compositeArtifacts.xml")) {
                return this.parseCompositeArtifacts(cycles, this.hideAndSeek(uri), uri);
            }
            if (type.endsWith("/artifacts.xml.xz")) {
                return this.parseArtifacts(this.hideAndSeek(uri), uri);
            }
            if (type.endsWith("/artifacts.xml")) {
                return this.parseArtifacts(this.hideAndSeek(uri), uri);
            }
            if (type.endsWith("/p2.index")) {
                return this.parseIndexArtifacts(cycles, uri);
            }
            uri = this.normalize(uri).resolve("p2.index");
            this.defaults.add(uri);
            return this.parseIndexArtifacts(cycles, uri);
        }
        catch (Exception e) {
            return Promises.failed((Throwable)e);
        }
    }

    private Promise<List<Artifact>> parseArtifacts(final InputStream in, final URI uri) throws Exception {
        if (in == null) {
            return RESOLVED;
        }
        final Deferred deferred = new Deferred();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArtifactRepository ar = new ArtifactRepository(in, uri);
                    deferred.resolve(ar.getArtifacts());
                }
                catch (Throwable e) {
                    deferred.fail(e);
                }
                finally {
                    IO.close(in);
                }
            }
        });
        return deferred.getPromise();
    }

    private Promise<List<Artifact>> parseCompositeArtifacts(Set<URI> cycles, InputStream in, URI base) throws Exception {
        if (in == null) {
            return RESOLVED;
        }
        CompositeArtifacts ca = new CompositeArtifacts(in);
        ca.parse();
        return this.getArtifacts(cycles, ca.uris);
    }

    private Promise<List<Artifact>> getArtifacts(final Set<URI> cycles, final Collection<URI> uris) {
        final Deferred deferred = new Deferred();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Promise> promises = new ArrayList<Promise>(uris.size());
                    for (final URI uri : uris) {
                        URI nuri = P2Impl.this.base.resolve(uri);
                        promises.add(P2Impl.this.getArtifacts((Set<URI>)cycles, nuri).recover(new Function<Promise<?>, List<Artifact>>(){

                            public List<Artifact> apply(Promise<?> failed) {
                                if (!P2Impl.this.defaults.contains(uri)) {
                                    try {
                                        logger.info("Failed to get artifacts for %s", (Object)uri, (Object)failed.getFailure());
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                return Collections.emptyList();
                            }
                        }));
                    }
                    Promise all = Promises.all(promises);
                    deferred.resolveWith(all.map((Function)new Function<List<List<Artifact>>, List<Artifact>>(){

                        public List<Artifact> apply(List<List<Artifact>> lists) {
                            ArrayList<Artifact> result = new ArrayList<Artifact>();
                            for (List<Artifact> list : lists) {
                                result.addAll(list);
                            }
                            return result;
                        }
                    }));
                }
                catch (Throwable e) {
                    deferred.fail(e);
                }
            }
        });
        return deferred.getPromise();
    }

    private InputStream hideAndSeek(URI uri) throws Exception {
        if (uri.getPath().endsWith(".xz")) {
            File f = this.getFile(uri);
            if (f != null) {
                return this.tzStream(f);
            }
            return null;
        }
        URI xzname = this.replace(uri, "$", ".xz");
        File f = this.getFile(xzname);
        if (f != null) {
            return this.tzStream(f);
        }
        f = this.getFile(this.replace(uri, ".xml$", ".jar"));
        if (f != null) {
            return this.jarStream(f, Strings.getLastSegment(uri.getPath(), '/'));
        }
        f = this.getFile(uri);
        if (f != null) {
            return new FileInputStream(f);
        }
        if (!this.defaults.contains(uri)) {
            logger.error("Invalid uri {}", (Object)uri);
        }
        return null;
    }

    private File getFile(URI xzname) throws Exception {
        return (File)this.client.build().useCache().go(xzname);
    }

    private InputStream jarStream(File f, String name) throws IOException {
        final JarFile jaf = new JarFile(f);
        ZipEntry entry = jaf.getEntry(name);
        InputStream inputStream = jaf.getInputStream(entry);
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                jaf.close();
            }
        };
    }

    private InputStream tzStream(File f) throws Exception {
        return new XZInputStream(new FileInputStream(f));
    }

    private URI replace(URI uri, String where, String replacement) {
        String path = uri.getRawPath();
        return uri.resolve(path.replaceAll(where, replacement));
    }

    private Promise<List<Artifact>> parseIndexArtifacts(final Set<URI> cycles, final URI uri) throws Exception {
        Promise file = this.client.build().useCache().get().async(uri.toURL());
        return file.flatMap((Function)new Function<File, Promise<? extends List<Artifact>>>(){

            public Promise<List<Artifact>> apply(File file) {
                try {
                    return P2Impl.this.parseIndexArtifacts(cycles, uri, file);
                }
                catch (Throwable e) {
                    return Promises.failed((Throwable)e);
                }
            }
        });
    }

    private Promise<List<Artifact>> parseIndexArtifacts(Set<URI> cycles, URI uri, File file) throws Exception {
        P2Index index = file == null ? this.getDefaultIndex(uri) : this.parseIndex(file, uri);
        this.canonicalize(index.artifacts);
        this.canonicalize(index.content);
        return this.getArtifacts(cycles, index.artifacts);
    }

    private void canonicalize(List<URI> artifacts) throws URISyntaxException {
        if (artifacts.size() < 2) {
            return;
        }
        for (URI uri : new ArrayList<URI>(artifacts)) {
            if (!uri.getPath().endsWith(".xml")) continue;
            artifacts.remove(new URI(uri.toString() + ".xz"));
        }
    }

    private P2Index getDefaultIndex(URI base) {
        P2Index index = new P2Index();
        index.artifacts.add(base.resolve("compositeArtifacts.xml"));
        index.artifacts.add(base.resolve("artifacts.xml"));
        index.content.add(base.resolve("compositeContent.xml"));
        index.content.add(base.resolve("content.xml"));
        this.defaults.addAll(index.artifacts);
        this.defaults.addAll(index.content);
        return index;
    }

    private P2Index parseIndex(File file, URI base) throws IOException {
        Properties p = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            p.load(in);
        }
        String version = p.getProperty("version");
        if (version == null || Integer.parseInt(version) != 1) {
            throw new UnsupportedOperationException("The repository " + base + " specifies an index file with an incompatible version " + version);
        }
        P2Index index = new P2Index();
        this.addPaths(p.getProperty("metadata.repository.factory.order"), index.content, base);
        this.addPaths(p.getProperty("artifact.repository.factory.order"), index.artifacts, base);
        index.modified = file.lastModified();
        return index;
    }

    private void addPaths(String p, List<URI> index, URI base) {
        String path;
        Parameters content = new Parameters(p);
        Iterator i$ = content.keySet().iterator();
        while (i$.hasNext() && !"!".equals(path = (String)i$.next())) {
            URI sub = base.resolve(path);
            index.add(sub);
        }
    }
}

