package com.intellij.psi.css.descriptor;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public class CssPseudoSelectorDescriptorStub implements CssPseudoElementDescriptor, CssPseudoClassDescriptor, CssPseudoSelectorDescriptor {
  @NonNls private static final String EMPTY_STRING = "";
  private final String myName;
  private final boolean myElementSelector;

  public CssPseudoSelectorDescriptorStub(String name) {
    this(name, false);
  }

  public CssPseudoSelectorDescriptorStub(String name, boolean elementSelector) {
    myName = name;
    myElementSelector = elementSelector;
  }

  @NotNull
  @Override
  public String getId() {
    return myName;
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return (myElementSelector ? "::" : ":") + getId();
  }

  @NotNull
  @Override
  public CssVersion getCssVersion() {
    return CssVersion.UNKNOWN;
  }

  @NotNull
  @Override
  public BrowserVersion[] getBrowsers() {
    return BrowserVersion.EMPTY_ARRAY;
  }

  @Override
  public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
    return true;
  }

  @NotNull
  @Override
  public String getDescription() {
    return EMPTY_STRING;
  }

  @Nullable
  @Override
  public String getDocumentationString(@Nullable PsiElement context) {
    return null;
  }

  @NotNull
  @Override
  public String getElementTypeName() {
    return CssBundle.message("css.pseudo.selector");
  }

  @Nullable
  @Override
  public String getSpecificationUrl() {
    return null;
  }

  @NotNull
  @Override
  public CssContextType[] getAllowedContextTypes() {
    return CssContextType.EMPTY_ARRAY;
  }

  @Nullable
  @Override
  public Icon getIcon() {
    return myElementSelector ? AllIcons.Css.Pseudo_element : AllIcons.Css.Pseudo_class;
  }

  @Override
  public boolean hasArguments() {
    return false;
  }

  @Override
  public int getColonPrefixLength() {
    return myElementSelector ? 2 : 1;
  }

  @Override
  public boolean isElementRequired() {
    return false;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof CssPseudoSelectorDescriptorStub)) return false;

    CssPseudoSelectorDescriptorStub stub = (CssPseudoSelectorDescriptorStub)o;

    if (myName != null ? !myName.equals(stub.myName) : stub.myName != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    return myName != null ? myName.hashCode() : 0;
  }
}
