/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;

public class SpringJamComponentScan extends SpringJamComponentScanArchetype {

  private static final SemKey<SpringJamComponentScan> JAM_KEY = COMPONENT_SCAN_JAM_KEY.subKey("SpringJamComponentScan");
  public static final SemKey<SpringJamComponentScan> REPEATABLE_ANNO_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringJamComponentScan");

  public static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringAnnotationsConstants.COMPONENT_SCAN, ARCHETYPE, META_KEY);

  public static final JamClassMeta<SpringJamComponentScan> META =
    new JamClassMeta<>(null, SpringJamComponentScan.class, JAM_KEY).addAnnotation(ANNOTATION_META);

  public SpringJamComponentScan(@NotNull PsiClass psiElement) {
    super(psiElement);
  }

  public SpringJamComponentScan(PsiAnnotation annotation) {
    super(annotation);
  }

  @NotNull
  protected JamAnnotationMeta getAnnotationMeta() {
    return ANNOTATION_META;
  }

}
