/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.utils.resources;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.xml.beans.SpringProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public abstract class SpringResourcesUtil {

  public static SpringResourcesUtil getInstance() {
    return ServiceManager.getService(SpringResourcesUtil.class);
  }

  @NotNull
  public abstract <V extends PsiFileSystemItem> Collection<V> getResourceItems(final @NotNull SpringProperty property,
                                                                               final Condition<PsiFileSystemItem> filter);

  public abstract <V extends PsiFileSystemItem> Collection<V> getResourceItems(final PsiReference[] references,
                                                                               final Condition<PsiFileSystemItem> filter);

  public abstract PsiReference[] getReferences(final @NotNull SpringResourcesBuilder builder);

  public abstract PsiReference[] getClassPathReferences(final @NotNull SpringResourcesBuilder builder);

  @Nullable
  public abstract String getResourceFileReferenceString(final PsiFile resourceFile);
}
