/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view.panels;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.data.commons.view.SpringRepositoriesViewSettings;
import com.intellij.spring.data.commons.view.panels.SpringRepositoriesPanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRepositoryMethodPanel
extends FinderRecursivePanel<PsiMethod> {
    private final PsiClass myPsiClass;
    private SpringRepositoriesPanel myPanel;
    private DocumentationComponent myDocumentationComponent;

    public SpringRepositoryMethodPanel(@NotNull SpringRepositoriesPanel panel, @NotNull PsiClass psiClass) {
        if (panel == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(1);
        }
        super((FinderRecursivePanel)panel);
        this.myPanel = panel;
        this.myPsiClass = psiClass;
    }

    @Nullable
    protected JComponent createRightComponent(PsiMethod method) {
        return this.getDocumentationComponent((PsiElement)method);
    }

    public DocumentationComponent getDocumentationComponent(PsiElement element) {
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.myPanel.getProject());
        if (this.myDocumentationComponent == null) {
            this.myDocumentationComponent = new DocumentationComponent(manager);
            Disposer.register((Disposable)this, (Disposable)this.myDocumentationComponent);
        }
        manager.fetchDocInfo(element, this.myDocumentationComponent);
        return this.myDocumentationComponent;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent coloredComponent, JList list, PsiMethod method, int index, boolean selected, boolean hasFocus) {
        String name;
        coloredComponent.clear();
        coloredComponent.setIcon(this.getItemIcon(method));
        PsiClass containingClass = method.getContainingClass();
        boolean inheritedMethod = !this.myPsiClass.equals(containingClass);
        String signature = SpringRepositoryMethodPanel.getMethodSignature(method);
        coloredComponent.append(signature, inheritedMethod ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (inheritedMethod && containingClass != null && StringUtil.isNotEmpty((String)(name = containingClass.getName()))) {
            coloredComponent.append(UIUtil.rightArrow() + name, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static String getMethodSignature(PsiMethod method) {
        int options = 263;
        return method.isValid() ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2) : "";
    }

    @NotNull
    protected List<PsiMethod> getListItems() {
        List<PsiMethod> list = SpringRepositoryMethodPanel.getRepositoryMethods(this.myPsiClass);
        if (list == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        boolean showAllMethods;
        if (psiClass == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(3);
        }
        PsiMethod[] methods = (showAllMethods = SpringRepositoriesViewSettings.getInstance(psiClass.getProject()).isShowAllRepositoryMethods()) ? psiClass.getAllMethods() : psiClass.getMethods();
        return Arrays.stream(methods).filter(SpringRepositoryMethodPanel.getMethodFilter()).sorted(Comparator.comparing(PsiMethod::getName)).collect(Collectors.toList());
    }

    @NotNull
    private static Predicate<PsiMethod> getMethodFilter() {
        Predicate<PsiMethod> predicate = method -> {
            if (method.isConstructor()) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && !"java.lang.Object".equals(containingClass.getQualifiedName());
        };
        if (predicate == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(4);
        }
        return predicate;
    }

    @Nullable
    protected Icon getItemIcon(PsiMethod method) {
        return method.isValid() ? method.getIcon(0) : null;
    }

    protected boolean hasChildren(PsiMethod method) {
        return false;
    }

    @NotNull
    protected String getItemText(PsiMethod method) {
        String string = method.isValid() ? SpringRepositoryMethodPanel.getMethodSignature(method) : "";
        if (string == null) {
            SpringRepositoryMethodPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/view/panels/SpringRepositoryMethodPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/view/panels/SpringRepositoryMethodPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

