/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.inspections;

import com.intellij.batch.model.job.BatchNextStepsOwner;
import com.intellij.batch.model.job.CheckpointPolicy;
import com.intellij.batch.model.job.Chunk;
import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.model.job.Next;
import com.intellij.batch.model.job.Step;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BatchJobDomInspection
extends BasicDomElementsInspection<Job> {
    public BatchJobDomInspection() {
        super(Job.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        super.checkDomElement(element, holder, helper);
        if (element instanceof BatchNextStepsOwner) {
            BatchJobDomInspection.checkNextSteps((BatchNextStepsOwner)element, holder);
        }
        if (element instanceof Chunk) {
            BatchJobDomInspection.checkChunk((Chunk)element, holder);
        }
        if (element instanceof Step) {
            this.checkStep((Step)element, holder);
        }
    }

    private void checkStep(@NotNull Step step, @NotNull DomElementAnnotationHolder holder) {
        if (step == null) {
            BatchJobDomInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            BatchJobDomInspection.$$$reportNull$$$0(1);
        }
        if (DomUtil.hasXml((DomElement)step.getChunk()) && DomUtil.hasXml((DomElement)step.getBatchlet())) {
            holder.createProblem((DomElement)step, HighlightSeverity.WARNING, BatchBundle.message("chunk.and.batchlet.not.allowed", new Object[0]));
        }
    }

    private static void checkChunk(@NotNull Chunk chunk, @NotNull DomElementAnnotationHolder holder) {
        CheckpointPolicy policy;
        if (chunk == null) {
            BatchJobDomInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            BatchJobDomInspection.$$$reportNull$$$0(3);
        }
        if ((policy = (CheckpointPolicy)((Object)chunk.getCheckpointPolicy().getValue())) == CheckpointPolicy.CUSTOM && !DomUtil.hasXml((DomElement)chunk.getCheckpointAlgorithm())) {
            holder.createProblem(chunk.getCheckpointPolicy(), HighlightSeverity.WARNING, BatchBundle.message("required.checkpoint.algorithm", new Object[0]));
        }
        if (policy == CheckpointPolicy.ITEM && DomUtil.hasXml((DomElement)chunk.getCheckpointAlgorithm())) {
            holder.createProblem(chunk.getCheckpointPolicy(), HighlightSeverity.WARNING, BatchBundle.message("redundant.checkpoint.algorithm", new Object[0]));
        }
    }

    private static void checkNextSteps(@NotNull BatchNextStepsOwner step, @NotNull DomElementAnnotationHolder holder) {
        String jobId;
        if (step == null) {
            BatchJobDomInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            BatchJobDomInspection.$$$reportNull$$$0(5);
        }
        if ((jobId = step.getId().getStringValue()) != null) {
            GenericAttributeValue<Identified> stepNext = step.getNext();
            if (jobId.equals(stepNext.getStringValue())) {
                BatchJobDomInspection.addSelfReferenceProblem(holder, stepNext);
            }
            for (Next next : step.getNexts()) {
                GenericAttributeValue<Identified> to = next.getTo();
                if (!jobId.equals(to.getStringValue())) continue;
                BatchJobDomInspection.addSelfReferenceProblem(holder, to);
            }
        }
    }

    private static void addSelfReferenceProblem(DomElementAnnotationHolder holder, GenericAttributeValue stepNext) {
        holder.createProblem((DomElement)stepNext, HighlightSeverity.WARNING, BatchBundle.message("self.reference.is.prohibited", new Object[0]));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = BatchBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            BatchJobDomInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BatchBundle.message("job.xml.config.inspection", new Object[0]);
        if (string == null) {
            BatchJobDomInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            BatchJobDomInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/inspections/BatchJobDomInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/inspections/BatchJobDomInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkStep";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkChunk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkNextSteps";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

