/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteCredentials;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialog;
import com.intellij.util.AsyncProducer;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class RemoteToolEditorDialog
extends ToolEditorDialog {
    private RemoteConnectionSettingsForm myConnectionSettingsForm;

    RemoteToolEditorDialog(JComponent parent, String title) {
        super(parent, title);
    }

    protected void fillAdditionalOptionsPanel(@NotNull JPanel panel) {
        if (panel == null) {
            RemoteToolEditorDialog.$$$reportNull$$$0(0);
        }
        this.myConnectionSettingsForm = new RemoteConnectionSettingsForm(null, this.myDisposable);
        panel.add(this.myConnectionSettingsForm.createPanel());
    }

    protected RemoteTool createTool() {
        return new RemoteTool();
    }

    public RemoteTool getData() {
        RemoteTool tool = (RemoteTool)super.getData();
        tool.setConnectionId(this.myConnectionSettingsForm.getConnectionId());
        tool.setConnectionType(this.myConnectionSettingsForm.getConnectionType());
        return tool;
    }

    protected void setData(Tool tool, String[] existingGroups) {
        super.setData(tool, existingGroups);
        if (tool instanceof RemoteTool) {
            RemoteTool remoteTool = (RemoteTool)tool;
            this.myConnectionSettingsForm.setConnectionTypeAndId(remoteTool.getConnectionType(), remoteTool.getConnectionId());
        }
    }

    protected void addWorkingDirectoryBrowseAction(@NotNull TextFieldWithBrowseButton workingDirField) {
        if (workingDirField == null) {
            RemoteToolEditorDialog.$$$reportNull$$$0(1);
        }
        workingDirField.addActionListener((ActionListener)new RemoteBrowseActionListener(workingDirField.getTextField(), "Select working directory on the remote host", this.createRemoteDataProducer()).withFoldersOnly(true));
    }

    private AsyncProducer<RemoteCredentials> createRemoteDataProducer() {
        return consumer -> {
            RemoteDataProducer producer = new RemoteDataProducer().withComponentOwner(this.getContentPanel());
            if (this.getProject() != null) {
                producer = producer.withProject(this.getProject());
            }
            producer.produceRemoteData(this.myConnectionSettingsForm.getConnectionType(), this.myConnectionSettingsForm.getConnectionId(), (Consumer<RemoteCredentials>)consumer);
        };
    }

    protected void addProgramBrowseAction(@NotNull TextFieldWithBrowseButton programField) {
        if (programField == null) {
            RemoteToolEditorDialog.$$$reportNull$$$0(2);
        }
        programField.addActionListener((ActionListener)new RemoteBrowseActionListener(programField.getTextField(), "Select executable on the remote host", this.createRemoteDataProducer()).withFoldersOnly(false));
    }

    protected String getIdForHelpAction() {
        return "reference.settings.remote.ssh.ext.tools.create.tool";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programField";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolEditorDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillAdditionalOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addWorkingDirectoryBrowseAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgramBrowseAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

