/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.interaction.RemoteProcessUserInfo;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.ssh.legacy.SftpIdentityRepositoryFactory;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001b\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u001a"}, d2={"getIdentities", "", "Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "data", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;)[Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "remoteCredentialsToSessionConfig", "Lcom/intellij/ssh/SessionConfig;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "userInfo", "Lcom/jcraft/jsch/UserInfo;", "remoteCredentialsToSessionKey", "Lcom/intellij/ssh/SshSessionKey;", "computePort", "", "openSSHConfig", "Lcom/intellij/ssh/config/OpenSSHClientConfig;", "computeUserName", "", "remote-run"})
@JvmName(name="SshConnectionServiceUtil")
public final class SshConnectionServiceUtil {
    @Nullable
    public static final SftpIdentityInfo[] getIdentities(@NotNull RemoteCredentials data) {
        String privateKeyFile;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.KEY_PAIR) && (privateKeyFile = data.getPrivateKeyFile()) != null) {
            byte[] byArray;
            CharSequence charSequence = data.getPassphrase();
            if (charSequence == null || charSequence.length() == 0) {
                byArray = null;
            } else {
                charSequence = data.getPassphrase();
                Charset charset = Charsets.UTF_8;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = ((String)charSequence2).getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            }
            byte[] passphrase = byArray;
            return new SftpIdentityInfo[]{new SftpIdentityInfo(new File(privateKeyFile), null, passphrase, 2, null)};
        }
        return null;
    }

    @NotNull
    public static final SshSessionKey remoteCredentialsToSessionKey(@NotNull RemoteCredentials data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.userName");
        String string2 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.host");
        return new SshSessionKey(string, string2, data.getPort(), data.getPassword(), SshConnectionServiceUtil.getIdentities(data), SshConnectionService.Companion.getInstance().getIdentityRepositoryFactory(data));
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        ConnectionOwner connectionOwner = ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project);
        RemoteProcessUserInfo userInfo = new RemoteProcessUserInfo(connectionOwner, data, progressIndicator);
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(data, timeout, timeUnit, (UserInfo)userInfo);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ SessionConfig remoteCredentialsToSessionConfig$default(RemoteCredentials remoteCredentials, long l, TimeUnit timeUnit, Project project, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(remoteCredentials, l, timeUnit, project, progressIndicator);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, timeUnit, project, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, null, project, null, 20, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, 0L, null, project, null, 22, null);
    }

    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable UserInfo userInfo) {
        SftpIdentityInfo[] identities;
        Charset charset;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        int timeoutInMillis = SshConnectionUtil.toTimeoutInMillis((long)timeout, (TimeUnit)timeUnit);
        File knownHostsFile = null;
        File knownHostsFileCandidate = new File(SftpClientFactory.findSshDir(), "known_hosts");
        if (knownHostsFileCandidate.isFile() && knownHostsFileCandidate.canRead()) {
            knownHostsFile = knownHostsFileCandidate;
        }
        if (Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.KEY_PAIR)) {
            byte[] byArray;
            SftpIdentityInfo sftpIdentityInfo;
            SftpIdentityInfo[] sftpIdentityInfoArray = new SftpIdentityInfo[1];
            SftpIdentityInfo[] sftpIdentityInfoArray2 = sftpIdentityInfoArray;
            SftpIdentityInfo[] sftpIdentityInfoArray3 = sftpIdentityInfoArray;
            int n = 0;
            SftpIdentityInfo sftpIdentityInfo2 = sftpIdentityInfo;
            SftpIdentityInfo sftpIdentityInfo3 = sftpIdentityInfo;
            File file = new File(data.getPrivateKeyFile());
            File file2 = null;
            String string = data.getPassphrase();
            if (string != null) {
                String string2 = string;
                File file3 = file2;
                File file4 = file;
                SftpIdentityInfo sftpIdentityInfo4 = sftpIdentityInfo2;
                SftpIdentityInfo sftpIdentityInfo5 = sftpIdentityInfo3;
                int n2 = n;
                SftpIdentityInfo[] sftpIdentityInfoArray4 = sftpIdentityInfoArray2;
                SftpIdentityInfo[] sftpIdentityInfoArray5 = sftpIdentityInfoArray3;
                charset = Charsets.UTF_8;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                sftpIdentityInfoArray3 = sftpIdentityInfoArray5;
                sftpIdentityInfoArray2 = sftpIdentityInfoArray4;
                n = n2;
                sftpIdentityInfo3 = sftpIdentityInfo5;
                sftpIdentityInfo2 = sftpIdentityInfo4;
                file = file4;
                file2 = file3;
                byArray = byArray3;
            } else {
                byArray = null;
            }
            sftpIdentityInfo2(file, file2, byArray, 2, null);
            sftpIdentityInfoArray2[n] = sftpIdentityInfo3;
            identities = sftpIdentityInfoArray3;
        } else {
            identities = null;
        }
        OpenSSHClientConfig openSSHConfig = Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.OPEN_SSH) ? OpenSSHConfigService.Companion.getInstance().getConfig() : null;
        String string = SshConnectionServiceUtil.computeUserName(data, openSSHConfig);
        String string4 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.host");
        charset = openSSHConfig;
        File file = knownHostsFile;
        SftpIdentityRepositoryFactory sftpIdentityRepositoryFactory = SshConnectionService.Companion.getInstance().getIdentityRepositoryFactory(data);
        SftpIdentityInfo[] sftpIdentityInfoArray = identities;
        boolean bl = false;
        Integer n = null;
        Integer n3 = null;
        SocketFactory socketFactory = null;
        Proxy proxy = null;
        UserInfo userInfo2 = userInfo;
        Properties properties = SshConnectionUtil.createConfig();
        Integer n4 = timeoutInMillis;
        return new SessionConfig(string, string4, SshConnectionServiceUtil.computePort(data, openSSHConfig), null, properties, n4, userInfo2, proxy, socketFactory, n3, n, bl, file, sftpIdentityInfoArray, sftpIdentityRepositoryFactory, (OpenSSHClientConfig)charset, 3976, null);
    }

    private static final String computeUserName(@NotNull RemoteCredentials $receiver, OpenSSHClientConfig openSSHConfig) {
        String userName = $receiver.getUserName();
        if (userName == null) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("User is not specified in connection settings");
            }
            userName = openSSHConfig.getConfig($receiver.getHost()).getUser();
            if (userName == null) {
                throw (Throwable)new IllegalStateException("User is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return userName;
    }

    private static final int computePort(@NotNull RemoteCredentials $receiver, OpenSSHClientConfig openSSHConfig) {
        int port = $receiver.getPort();
        if (port == OpenSSHClientConfig.HostConfig.UNSPECIFIED_PORT) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("Port is not specified in connection settings");
            }
            port = openSSHConfig.getConfig($receiver.getHost()).getPort();
            if (port == -1) {
                throw (Throwable)new IllegalStateException("Port is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return port;
    }
}

