/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.impl;

import com.intellij.util.containers.EmptyIterator;
import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.EdgeIterator;
import org.gga.graph.Graph;

public class GraphImpl
implements Graph {
    private final int myV;
    private int myE;
    private final boolean myIsDigraph;
    private Edge[][] myEdges;

    public GraphImpl(int v, boolean isDigraph) {
        this.myV = v;
        this.myIsDigraph = isDigraph;
        this.myEdges = new Edge[v][];
    }

    @Override
    public int V() {
        return this.myV;
    }

    @Override
    public int E() {
        return this.myE;
    }

    @Override
    public boolean isDirected() {
        return this.myIsDigraph;
    }

    @Override
    public Edge edge(int v, int w) {
        Edge[] edges = this.myEdges[v];
        if (edges == null) {
            return null;
        }
        return edges[w];
    }

    @Override
    public Edge insert(int v, int w) {
        Edge edge = new Edge(v, w);
        this._insert(edge);
        return edge;
    }

    private void _insert(Edge e) {
        e.setIdx(this.myE);
        this._insert(e, e.v(), e.w());
        if (!this.myIsDigraph) {
            this._insert(e, e.w(), e.v());
        }
        ++this.myE;
    }

    private void _insert(Edge e, int v, int w) {
        Edge[] edges = this.myEdges[v];
        if (edges == null) {
            edges = new Edge[this.myV];
            this.myEdges[v] = edges;
        }
        this.myEdges[v][w] = e;
    }

    @Override
    public void remove(Edge e) {
        this._remove(e.v(), e.w());
        if (!this.myIsDigraph) {
            this._remove(e.w(), e.v());
        }
        --this.myE;
    }

    @Override
    public EdgeIterator getEdgeIterator(int v) {
        Edge[] edges = this.myEdges[v];
        if (edges == null) {
            return EdgeIterator.EMPTY;
        }
        int first = -1;
        for (int i = 0; i < edges.length; ++i) {
            Edge edge = edges[i];
            if (edge == null) continue;
            first = i;
            break;
        }
        return new MyEdgeIterator(first, edges);
    }

    private void _remove(int v, int w) {
        this.myEdges[v][w] = null;
    }

    @Override
    public Iterator<Edge> getEdges(int v) {
        Edge[] edges = this.myEdges[v];
        if (edges == null) {
            return EmptyIterator.getInstance();
        }
        return GraphImpl.getEdges(edges);
    }

    static Iterator<Edge> getEdges(final Edge[] edges) {
        int first = -1;
        for (int i = 0; i < edges.length; ++i) {
            Edge edge = edges[i];
            if (edge == null) continue;
            first = i;
            break;
        }
        final int _f = first;
        return new Iterator<Edge>(){
            int curEdge;
            {
                this.curEdge = _f;
            }

            @Override
            public boolean hasNext() {
                return this.curEdge >= 0 && edges[this.curEdge] != null;
            }

            @Override
            public Edge next() {
                Edge e = edges[this.curEdge];
                int next = -1;
                for (int i = this.curEdge + 1; i < edges.length; ++i) {
                    Edge edge = edges[i];
                    if (edge == null) continue;
                    next = i;
                    break;
                }
                this.curEdge = next;
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Method remove not implemented in ");
            }
        };
    }

    private class MyEdgeIterator
    implements EdgeIterator {
        int curEdge;
        private final Edge[] edges;

        public MyEdgeIterator(int first, Edge[] edges) {
            this.edges = edges;
            this.curEdge = first;
        }

        @Override
        public EdgeIterator clone() {
            return new MyEdgeIterator(this.curEdge, this.edges);
        }

        @Override
        public Edge edge() {
            return this.edges[this.curEdge];
        }

        @Override
        public void advance() {
            int next = -1;
            for (int i = this.curEdge + 1; i < this.edges.length; ++i) {
                Edge edge = this.edges[i];
                if (edge == null) continue;
                next = i;
                break;
            }
            this.curEdge = next;
        }

        @Override
        public boolean hasNext() {
            if (this.isAfterEnd()) {
                return false;
            }
            for (int i = this.curEdge + 1; i < this.edges.length; ++i) {
                Edge edge = this.edges[i];
                if (edge == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAfterEnd() {
            return this.curEdge < 0;
        }
    }
}

