/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class KotlinVfsUtil {
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final String PROTOCOL_DELIMITER = ":";

    @NotNull
    public static String convertFromUrl(@NotNull URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (JAR.equals(protocol)) {
            if (StringUtil.startsWithConcatenationOf((String)path, (String)FILE, (String)PROTOCOL_DELIMITER)) {
                URL subURL = new URL(path);
                path = subURL.getPath();
            } else {
                throw new MalformedURLException("Can't parse url: " + url.toExternalForm());
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences((String)path);
        return protocol + "://" + path;
    }

    private KotlinVfsUtil() {
    }
}

