/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.SimpleNodeCellEditor;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.renderer.BasicGraphNodeRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.OrientationLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.seam.graph.PageflowEdge;
import com.intellij.seam.graph.PageflowNode;
import com.intellij.seam.graph.renderers.DefaultPageflowNodeRenderer;
import com.intellij.seam.model.xml.pageflow.PageflowNamedElement;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.xml.DomElement;
import java.awt.Color;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class PageflowPresentationModel
extends BasicGraphPresentationModel<PageflowNode, PageflowEdge> {
    private final Project myProject;
    private BasicGraphNodeRenderer myRenderer;

    public PageflowPresentationModel(Graph2D graph, Project project) {
        super((Graph)graph);
        this.myProject = project;
        this.setShowEdgeLabels(true);
        PageflowPresentationModel.customizeDefaultSettings(GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)graph));
    }

    private static void customizeDefaultSettings(GraphSettings settings) {
        HierarchicGroupLayouter groupLayouter = settings.getGroupLayouter();
        groupLayouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(OrientationLayouter.TOP_TO_BOTTOM));
        groupLayouter.setMinimalNodeDistance(20.0);
        groupLayouter.setMinimalLayerDistance(50.0);
        groupLayouter.setRoutingStyle(HierarchicLayouter.ROUTE_POLYLINE);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(PageflowNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"PageflowNodeRenderer", (NodeCellRenderer)this.getRenderer());
        if (nodeRealizer == null) {
            PageflowPresentationModel.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    public BasicGraphNodeRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new DefaultPageflowNodeRenderer((GraphBuilder<PageflowNode, PageflowEdge>)this.getGraphBuilder());
        }
        return this.myRenderer;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(PageflowEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        edgeRealizer.setLineColor(Color.GRAY);
        edgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            PageflowPresentationModel.$$$reportNull$$$0(1);
        }
        return polyLineEdgeRealizer;
    }

    public boolean editNode(PageflowNode node) {
        return super.editNode((Object)node);
    }

    public boolean editEdge(PageflowEdge pageflowEdge) {
        XmlElement xmlElement = pageflowEdge.getIdentifyingElement().getXmlElement();
        if (xmlElement instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)xmlElement});
            return true;
        }
        return super.editEdge((Object)pageflowEdge);
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getNodeTooltip(PageflowNode node) {
        return node.getName();
    }

    public String getEdgeTooltip(PageflowEdge edge) {
        return edge.getName();
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        editMode.allowEdgeCreation(true);
        editMode.allowBendCreation(false);
        view.setFitContentOnResize(false);
        view.fitContent();
    }

    public DeleteProvider getDeleteProvider() {
        return new DeleteProvider<PageflowNode, PageflowEdge>(){

            public boolean canDeleteNode(@NotNull PageflowNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !((CellEditorMode)PageflowPresentationModel.this.getGraphBuilder().getEditMode().getEditNodeMode()).isCellEditing();
            }

            public boolean canDeleteEdge(@NotNull PageflowEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean deleteNode(final @NotNull PageflowNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                new WriteCommandAction(PageflowPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        node.getIdentifyingElement().undefine();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PageflowPresentationModel$1$1", "run"));
                    }
                }.execute();
                return true;
            }

            public boolean deleteEdge(final @NotNull PageflowEdge edge) {
                if (edge == null) {
                    1.$$$reportNull$$$0(3);
                }
                new WriteCommandAction(PageflowPresentationModel.this.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        edge.getIdentifyingElement().undefine();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PageflowPresentationModel$1$2", "run"));
                    }
                }.execute();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "edge";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/seam/graph/PageflowPresentationModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canDeleteEdge";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deleteEdge";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public NodeCellEditor getCustomNodeCellEditor(PageflowNode pageflowNode) {
        return new SimpleNodeCellEditor<PageflowNode>(pageflowNode, this.getProject()){

            protected String getEditorValue(PageflowNode value) {
                String s = value.getName();
                return s == null ? "" : s;
            }

            protected void setEditorValue(PageflowNode value, String newValue) {
                Object element = value.getIdentifyingElement();
                if (element instanceof PageflowNamedElement) {
                    new WriteCommandAction(PageflowPresentationModel.this.myProject, new PsiFile[0], (DomElement)element, newValue){
                        final /* synthetic */ DomElement val$element;
                        final /* synthetic */ String val$newValue;
                        {
                            this.val$element = domElement;
                            this.val$newValue = string;
                            super(arg0, arg1);
                        }

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ((PageflowNamedElement)this.val$element).getName().setStringValue(this.val$newValue);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/seam/graph/PageflowPresentationModel$2$1", "run"));
                        }
                    }.execute();
                }
                IdeFocusManager.getInstance((Project)PageflowPresentationModel.this.getProject()).requestFocus((Component)PageflowPresentationModel.this.getGraphBuilder().getView().getJComponent(), true);
            }
        };
    }

    public DefaultActionGroup getNodeActionGroup(PageflowNode pageflowNode) {
        DefaultActionGroup group = super.getNodeActionGroup((Object)pageflowNode);
        group.add(ActionManager.getInstance().getAction("Pageflow.Designer"), Constraints.FIRST);
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/graph/PageflowPresentationModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

