/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceAnnotationMethodInfo;
import org.eclipse.jdt.internal.core.SourceConstructorInfo;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceMethodInfo;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.TypeParameter;
import org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected ICompilationUnit unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected Stack handleStack;
    protected int referenceCount = 0;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static String[] NO_STRINGS = new String[0];
    protected static byte[] NO_BYTES = new byte[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue(false);
        }
        ICompilationUnit parentCU = (ICompilationUnit)((Object)parentHandle);
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            parentInfo.addChild(importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        String elementName = JavaModelManager.getJavaModelManager().intern(new String(name));
        ImportDeclaration handle = new ImportDeclaration(importContainer, elementName, onDemand);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        this.importContainerInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        PackageDeclaration handle = null;
        if (parentHandle.getElementType() == 5) {
            handle = new PackageDeclaration((CompilationUnit)parentHandle, new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptProblem(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return NO_STRINGS;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = manager.intern(Signature.createTypeSignature(typeNames[i], false));
            ++i;
        }
        return typeSigs;
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        this.enterMethod(methodInfo);
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7) {
            String fieldName = JavaModelManager.getJavaModelManager().intern(new String(fieldInfo.name));
            handle = new SourceField(parentHandle, fieldName);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setNameSourceStart(fieldInfo.nameSourceStart);
        info.setNameSourceEnd(fieldInfo.nameSourceEnd);
        info.setSourceRangeStart(fieldInfo.declarationStart);
        info.setFlags(fieldInfo.modifiers);
        char[] typeName = JavaModelManager.getJavaModelManager().intern(fieldInfo.type);
        info.setTypeName(typeName);
        this.unitInfo.addAnnotationPositions(handle, fieldInfo.annotationPositions);
        parentInfo.addChild(handle);
        parentInfo.addCategories(handle, fieldInfo.categories);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        Initializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new Initializer(parentHandle, 1);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        InitializerElementInfo info = new InitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        char[] cArray;
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceMethod handle = null;
        if (methodInfo.parameterTypes == null) {
            methodInfo.parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.parameterNames == null) {
            methodInfo.parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (methodInfo.exceptionTypes == null) {
            methodInfo.exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(methodInfo.parameterTypes);
        if (parentHandle.getElementType() == 7) {
            String selector = JavaModelManager.getJavaModelManager().intern(new String(methodInfo.name));
            handle = new SourceMethod(parentHandle, selector, parameterTypeSigs);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = methodInfo.isConstructor ? new SourceConstructorInfo() : (methodInfo.isAnnotation ? new SourceAnnotationMethodInfo() : new SourceMethodInfo());
        info.setSourceRangeStart(methodInfo.declarationStart);
        int flags = methodInfo.modifiers;
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setFlags(flags);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[][] parameterNames = methodInfo.parameterNames;
        int i = 0;
        int length = parameterNames.length;
        while (i < length) {
            parameterNames[i] = manager.intern(parameterNames[i]);
            ++i;
        }
        info.setArgumentNames(parameterNames);
        if (methodInfo.returnType == null) {
            char[] cArray2 = new char[4];
            cArray2[0] = 118;
            cArray2[1] = 111;
            cArray2[2] = 105;
            cArray = cArray2;
            cArray2[3] = 100;
        } else {
            cArray = methodInfo.returnType;
        }
        char[] returnType = cArray;
        info.setReturnType(manager.intern(returnType));
        char[][] exceptionTypes = methodInfo.exceptionTypes;
        info.setExceptionTypeNames(exceptionTypes);
        int i2 = 0;
        int length2 = exceptionTypes.length;
        while (i2 < length2) {
            exceptionTypes[i2] = manager.intern(exceptionTypes[i2]);
            ++i2;
        }
        this.unitInfo.addAnnotationPositions(handle, methodInfo.annotationPositions);
        parentInfo.addChild(handle);
        parentInfo.addCategories(handle, methodInfo.categories);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (methodInfo.typeParameters != null) {
            i2 = 0;
            length2 = methodInfo.typeParameters.length;
            while (i2 < length2) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = methodInfo.typeParameters[i2];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++i2;
            }
        }
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        String nameString = new String(typeInfo.name);
        SourceType handle = new SourceType(parentHandle, nameString);
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(typeInfo.declarationStart);
        info.setFlags(typeInfo.modifiers);
        info.setNameSourceStart(typeInfo.nameSourceStart);
        info.setNameSourceEnd(typeInfo.nameSourceEnd);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[] superclass = typeInfo.superclass;
        info.setSuperclassName(superclass == null ? null : manager.intern(superclass));
        char[][] superinterfaces = typeInfo.superinterfaces;
        int i = 0;
        int length = superinterfaces == null ? 0 : superinterfaces.length;
        while (i < length) {
            superinterfaces[i] = manager.intern(superinterfaces[i]);
            ++i;
        }
        info.setSuperInterfaceNames(superinterfaces);
        info.addCategories(handle, typeInfo.categories);
        if (parentHandle.getElementType() == 7) {
            ((SourceTypeElementInfo)parentInfo).addCategories(handle, typeInfo.categories);
        }
        parentInfo.addChild(handle);
        this.unitInfo.addAnnotationPositions(handle, typeInfo.annotationPositions);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
        if (typeInfo.typeParameters != null) {
            i = 0;
            length = typeInfo.typeParameters.length;
            while (i < length) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i];
                this.enterTypeParameter(typeParameterInfo);
                this.exitMember(typeParameterInfo.declarationEnd);
                ++i;
            }
        }
    }

    protected void enterTypeParameter(ISourceElementRequestor.TypeParameterInfo typeParameterInfo) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        String nameString = new String(typeParameterInfo.name);
        TypeParameter handle = new TypeParameter(parentHandle, nameString);
        this.resolveDuplicates(handle);
        TypeParameterElementInfo info = new TypeParameterElementInfo();
        info.setSourceRangeStart(typeParameterInfo.declarationStart);
        info.nameStart = typeParameterInfo.nameSourceStart;
        info.nameEnd = typeParameterInfo.nameSourceEnd;
        info.bounds = typeParameterInfo.bounds;
        if (parentInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)parentInfo;
            ITypeParameter[] typeParameters = elementInfo.typeParameters;
            int length = typeParameters.length;
            ITypeParameter[] iTypeParameterArray = typeParameters;
            typeParameters = new ITypeParameter[length + 1];
            System.arraycopy(iTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.typeParameters = typeParameters;
        } else {
            SourceMethodElementInfo elementInfo = (SourceMethodElementInfo)parentInfo;
            ITypeParameter[] typeParameters = elementInfo.typeParameters;
            int length = typeParameters.length;
            ITypeParameter[] iTypeParameterArray = typeParameters;
            typeParameters = new ITypeParameter[length + 1];
            System.arraycopy(iTypeParameterArray, 0, typeParameters, 0, length);
            typeParameters[length] = handle;
            elementInfo.typeParameters = typeParameters;
        }
        this.unitInfo.addAnnotationPositions(handle, typeParameterInfo.annotationPositions);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.unitInfo.setSourceLength(declarationEnd + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int length;
        Object typeInfo;
        int flags;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        if (initializationStart != -1 && (Flags.isStatic(flags = info.flags) && Flags.isFinal(flags) || (typeInfo = this.infoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)typeInfo).flags)) && (length = declarationEnd - initializationStart) > 0) {
            char[] initializer = new char[length];
            System.arraycopy(this.parser.scanner.source, initializationStart, initializer, 0, length);
            info.initializationSource = initializer;
        }
        this.handleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.handleStack.pop();
    }

    public void exitMethod(int declarationEnd, int defaultValueStart, int defaultValueEnd) {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        if (info.isAnnotationMethod()) {
            SourceAnnotationMethodInfo annotationMethodInfo = (SourceAnnotationMethodInfo)info;
            annotationMethodInfo.defaultValueStart = defaultValueStart;
            annotationMethodInfo.defaultValueEnd = defaultValueEnd;
        }
        this.handleStack.pop();
    }

    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(SourceRefElement handle) {
        while (this.newElements.containsKey(handle)) {
            ++handle.occurrenceCount;
        }
    }
}

