/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbManager;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidSynchronizeHandler;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDataSourceConfigurable
extends AbstractDataSourceConfigurable<AndroidDbManager, AndroidDataSource>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDataSourcePropertiesDialog");
    private static final String[] DEFAULT_EXTERNAL_DB_PATTERNS = new String[]{"files/"};
    private DefaultComboBoxModel<Object> myDeviceComboBoxModel;
    private String myMissingDeviceIds;
    private DatabaseNameComponent myNameComponent;
    private ComboBox myDeviceComboBox;
    private ComboBox myPackageNameComboBox;
    private ComboBox myDataBaseComboBox;
    private JPanel myPanel;
    private JPanel myConfigurationPanel;
    private JBRadioButton myExternalStorageRadioButton;
    private JBRadioButton myInternalStorageRadioButton;
    private IDevice mySelectedDevice;
    private final Map<String, List<String>> myDatabaseMap;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceListener;
    private final AndroidDataSource myTempDataSource;

    protected AndroidDataSourceConfigurable(@NotNull AndroidDbManager manager, @NotNull Project project, @NotNull AndroidDataSource dataSource) {
        if (manager == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        super((DbPsiManagerSpi)manager, (DatabaseSystem)dataSource, project);
        this.$$$setupUI$$$();
        this.myDeviceComboBoxModel = new DefaultComboBoxModel();
        this.mySelectedDevice = null;
        this.myDatabaseMap = ContainerUtil.newLinkedHashMap();
        this.myTempDataSource = dataSource.copy();
        this.myDeviceListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(IDevice device) {
                AndroidDataSourceConfigurable.this.addDeviceToComboBoxIfNeeded(device);
            }

            public void deviceDisconnected(IDevice device) {
            }

            public void deviceChanged(IDevice device, int changeMask) {
                if ((changeMask & 1) == changeMask) {
                    AndroidDataSourceConfigurable.this.addDeviceToComboBoxIfNeeded(device);
                }
            }
        };
    }

    @Nullable
    public JComponent createComponent() {
        this.myNameComponent = new DatabaseNameComponent((AbstractDatabaseConfigurable)this, this.myController);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myConfigurationPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myDeviceComboBox.setRenderer((ListCellRenderer)new DeviceRenderer.DeviceComboBoxRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value instanceof String) {
                    this.append(AndroidDbUtil.getPresentableNameFromDeviceId((String)value));
                } else {
                    super.customizeCellRenderer(list, value, index, selected, hasFocus);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/database/AndroidDataSourceConfigurable$2", "customizeCellRenderer"));
            }
        });
        this.myDeviceComboBox.setPreferredSize(new Dimension(JBUI.scale((int)300), this.myDeviceComboBox.getPreferredSize().height));
        this.myDeviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidDataSourceConfigurable.this.updateDataBases();
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidDataSourceConfigurable.this.updateDbCombo();
            }
        };
        this.myPackageNameComboBox.addActionListener(l);
        this.myExternalStorageRadioButton.addActionListener(l);
        this.myInternalStorageRadioButton.addActionListener(l);
        new UiNotifyConnector.Once((Component)this.myPanel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                AndroidDataSourceConfigurable.this.loadDevices();
                AndroidDataSourceConfigurable.this.updateDataBases();
                AndroidDataSourceConfigurable.this.updateDbCombo();
                AndroidDataSourceConfigurable.this.registerDeviceListener();
            }
        });
        return this.myPanel;
    }

    @NotNull
    public AndroidDataSource getTempDataSource() {
        this.saveData(this.myTempDataSource);
        AndroidDataSource androidDataSource = this.myTempDataSource;
        if (androidDataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return androidDataSource;
    }

    private void addDeviceToComboBoxIfNeeded(final @NotNull IDevice device) {
        if (device == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!device.isOnline()) {
                    return;
                }
                String deviceId = AndroidDbUtil.getDeviceId(device);
                if (deviceId == null || deviceId.length() == 0) {
                    return;
                }
                for (int i = 0; i < AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.getSize(); ++i) {
                    Object element = AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.getElementAt(i);
                    if (!device.equals(element)) continue;
                    return;
                }
                AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.addElement(device);
                if (AndroidDataSourceConfigurable.this.myMissingDeviceIds != null && AndroidDataSourceConfigurable.this.myMissingDeviceIds.equals(deviceId)) {
                    AndroidDataSourceConfigurable.this.myDeviceComboBoxModel.removeElement(AndroidDataSourceConfigurable.this.myMissingDeviceIds);
                    AndroidDataSourceConfigurable.this.myMissingDeviceIds = null;
                }
            }
        }, ModalityState.stateForComponent((Component)this.myPanel));
    }

    private void loadDevices() {
        AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        IDevice[] devices = bridge != null ? AndroidDataSourceConfigurable.getDevicesWithValidDeviceId(bridge) : new IDevice[]{};
        String deviceId = ((AndroidDataSource)this.myDataSource).getState().deviceId;
        DefaultComboBoxModel<IDevice> model = new DefaultComboBoxModel<IDevice>(devices);
        String selectedItem = null;
        if (deviceId != null && deviceId.length() > 0) {
            for (IDevice device : devices) {
                if (!deviceId.equals(AndroidDbUtil.getDeviceId(device))) continue;
                selectedItem = device;
                break;
            }
            if (selectedItem == null) {
                model.addElement((IDevice)deviceId);
                this.myMissingDeviceIds = deviceId;
                selectedItem = deviceId;
            }
        }
        this.myDeviceComboBoxModel = model;
        this.myDeviceComboBox.setModel(model);
        if (selectedItem != null) {
            this.myDeviceComboBox.setSelectedItem(selectedItem);
        }
    }

    @NotNull
    private static IDevice[] getDevicesWithValidDeviceId(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            String deviceId;
            if (!device.isOnline() || (deviceId = AndroidDbUtil.getDeviceId(device)) == null || deviceId.length() <= 0) continue;
            result.add(device);
        }
        IDevice[] iDeviceArray = result.toArray(new IDevice[result.size()]);
        if (iDeviceArray == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(6);
        }
        return iDeviceArray;
    }

    private void updateDataBases() {
        IDevice selectedDevice;
        if (!this.myPanel.isShowing()) {
            return;
        }
        Object selectedItem = this.myDeviceComboBox.getSelectedItem();
        IDevice iDevice = selectedDevice = selectedItem instanceof IDevice ? (IDevice)selectedItem : null;
        if (selectedDevice == null) {
            this.myDatabaseMap.clear();
            this.myPackageNameComboBox.setModel(new DefaultComboBoxModel());
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel());
        } else if (!selectedDevice.equals(this.mySelectedDevice)) {
            this.loadDatabases(selectedDevice);
            this.myPackageNameComboBox.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(this.myDatabaseMap.keySet())));
            this.updateDbCombo();
        }
        this.mySelectedDevice = selectedDevice;
    }

    private void updateDbCombo() {
        boolean databaseIsCustom;
        if (!this.myPanel.isShowing()) {
            return;
        }
        String selectedPackage = this.getSelectedPackage();
        String selectedDatabase = this.getSelectedDatabase();
        boolean bl = databaseIsCustom = StringUtil.isNotEmpty((String)selectedDatabase) && ((DefaultComboBoxModel)this.myDataBaseComboBox.getModel()).getIndexOf(selectedDatabase) < 0;
        if (this.myInternalStorageRadioButton.isSelected()) {
            List<String> dbList = this.myDatabaseMap.get(selectedPackage);
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(dbList)));
        } else {
            this.myDataBaseComboBox.setModel(new DefaultComboBoxModel<String>(DEFAULT_EXTERNAL_DB_PATTERNS));
        }
        if (databaseIsCustom) {
            this.myDataBaseComboBox.getEditor().setItem(selectedDatabase);
        }
    }

    @NotNull
    private String getSelectedPackage() {
        String string = (String)this.myPackageNameComboBox.getEditor().getItem();
        if (string == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getSelectedDatabase() {
        String string = (String)this.myDataBaseComboBox.getEditor().getItem();
        if (string == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void loadDatabases(@NotNull IDevice device) {
        if (device == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(9);
        }
        this.myDatabaseMap.clear();
        FileListingService service = device.getFileListingService();
        if (service == null) {
            return;
        }
        HashSet packages = new HashSet();
        for (AndroidFacet facet : ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)) {
            String aPackage;
            Manifest manifest = facet.getManifest();
            if (manifest == null || (aPackage = manifest.getPackage().getStringValue()) == null || aPackage.length() <= 0) continue;
            packages.add(aPackage);
        }
        if (packages.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean tooLong = false;
        for (String aPackage : packages) {
            this.myDatabaseMap.put(aPackage, tooLong ? Collections.emptyList() : AndroidDataSourceConfigurable.loadDatabases(device, aPackage));
            if (System.currentTimeMillis() - startTime <= 4000L) continue;
            tooLong = true;
        }
    }

    @NotNull
    private static List<String> loadDatabases(@NotNull IDevice device, @NotNull String packageName) {
        if (device == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(10);
        }
        if (packageName == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(11);
        }
        final ArrayList<String> result = new ArrayList<String>();
        try {
            device.executeShellCommand("run-as " + packageName + " ls " + AndroidDbUtil.getInternalDatabasesRemoteDirPath(packageName), (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    for (String line : lines) {
                        if (line.length() <= 0 || line.contains(" ")) continue;
                        result.add(line);
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            }, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private String getSelectedDeviceId() {
        Object item = this.myDeviceComboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        if (item instanceof String) {
            return (String)item;
        }
        assert (item instanceof IDevice);
        String deviceId = AndroidDbUtil.getDeviceId((IDevice)item);
        return deviceId != null ? deviceId : "";
    }

    public void saveData(@NotNull AndroidDataSource dataSource) {
        if (dataSource == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(13);
        }
        this.myNameComponent.apply((AbstractDataSource)dataSource);
        AndroidDataSource.State state = dataSource.getState();
        state.deviceId = this.getSelectedDeviceId();
        state.packageName = this.getSelectedPackage();
        state.databaseName = this.getSelectedDatabase();
        state.external = this.myExternalStorageRadioButton.isSelected();
        dataSource.resetUrl();
    }

    public void apply() {
        this.saveData((AndroidDataSource)this.myDataSource);
        if (DbImplUtil.canConnectTo((LocalDataSource)((LocalDataSource)this.myDataSource))) {
            AndroidSynchronizeHandler.doSynchronize(this.myProject, Collections.singletonList(this.myDataSource));
        }
        if (this.isNewDataSource()) {
            ((AndroidDbManager)this.myManager).processAddOrRemove((AndroidDataSource)this.myDataSource, true);
        }
    }

    protected void reset(@NotNull AndroidDataSource o) {
        if (o == null) {
            AndroidDataSourceConfigurable.$$$reportNull$$$0(14);
        }
        AndroidDataSource.State state = o.getState();
        this.myNameComponent.reset((AbstractDataSource)o);
        this.myInternalStorageRadioButton.setSelected(!state.external);
        this.myExternalStorageRadioButton.setSelected(state.external);
        this.myPackageNameComboBox.getEditor().setItem(StringUtil.notNullize((String)state.packageName));
        this.myDataBaseComboBox.getEditor().setItem(StringUtil.notNullize((String)state.databaseName));
    }

    private void registerDeviceListener() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)AndroidDataSourceConfigurable.this.myDeviceListener);
            }
        });
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @Nls
    public String getDisplayName() {
        return this.myNameComponent.getNameValue();
    }

    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        AndroidDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((AndroidDataSource)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSourceConfigurable";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevicesWithValidDeviceId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPackage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDatabase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDatabases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDeviceToComboBoxIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDevicesWithValidDeviceId";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadDatabases";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myConfigurationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "");
        jPanel.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jPanel, "Center");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Device:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceComboBox = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(0, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Package name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Database:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataBaseComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 3, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Storage:");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myInternalStorageRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Internal");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myExternalStorageRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("External");
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

