/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ChangelogImpl;
import com.intellij.zkm.bytecode.ClassDataImpl;
import com.intellij.zkm.bytecode.Modifier;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.TypeFactory;
import com.intellij.zkm.bytecode.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ChangelogReader {
    private static final Pattern PARAMETER_SEPARATOR = Pattern.compile(", ");
    private static final Pattern MODIFIER_SEPARATOR = Pattern.compile(" ");
    private final TypeFactory myTypes;

    ChangelogReader(@NotNull TypeFactory types) {
        if (types == null) {
            ChangelogReader.$$$reportNull$$$0(0);
        }
        this.myTypes = types;
    }

    @NotNull
    Changelog read(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            ChangelogReader.$$$reportNull$$$0(1);
        }
        State state = State.INITIAL;
        HashMap<String, ClassDataImpl> classes = new HashMap<String, ClassDataImpl>();
        String className = null;
        ClassDataImpl classData = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) {
                state = State.INITIAL;
                if (className == null || classData.isEmpty()) continue;
                classes.put(className, classData);
                className = null;
                continue;
            }
            switch (state) {
                case INITIAL: {
                    if (line.startsWith("Class:")) {
                        state = State.CLASS;
                        classData = new ClassDataImpl(classes);
                        if (line.endsWith("NameNotChanged")) {
                            int i = line.lastIndexOf(9);
                            className = line.substring(line.lastIndexOf(32, i - 1) + 1, i);
                            break;
                        }
                        int i1 = line.lastIndexOf(9);
                        className = line.substring(i1 + 1);
                        int i2 = line.lastIndexOf(9, i1 - 1);
                        classData.setClassName(line.substring(line.lastIndexOf(32, i2 - 1) + 1, i2));
                        break;
                    }
                    if (!(line.startsWith("TraceBackClass:") | line.startsWith("ForwardClass:") | line.startsWith("MemberClass:"))) break;
                    break;
                }
                case CLASS: {
                    if (line.startsWith("\tSource:")) {
                        state = State.SOURCE;
                        classData.setSourceFile(line.substring(10, line.length() - 1));
                        break;
                    }
                    if (!line.startsWith("\tMethodsOf:")) break;
                    state = State.METHODS;
                    break;
                }
                case SOURCE: {
                    if (!line.startsWith("\tMethodsOf:")) break;
                    state = State.METHODS;
                    break;
                }
                case METHODS: {
                    if (line.endsWith("NameNotChanged")) break;
                    int openParenIndex = line.indexOf(40);
                    int closeParenIndex = line.indexOf(41, openParenIndex + 1);
                    int spaceBeforeNameIndex = line.lastIndexOf(32, openParenIndex - 1);
                    int spaceBeforeReturnTypeIndex = line.lastIndexOf(32, spaceBeforeNameIndex - 1);
                    if (spaceBeforeReturnTypeIndex < 0) {
                        spaceBeforeReturnTypeIndex = 2;
                    }
                    String[] modifierNames = Utilities.split(line.substring(2, spaceBeforeReturnTypeIndex), MODIFIER_SEPARATOR);
                    String originalName = line.substring(spaceBeforeNameIndex + 1, openParenIndex);
                    String returnType = line.substring(spaceBeforeReturnTypeIndex + 1, spaceBeforeNameIndex);
                    String[] parameterTypes = Utilities.split(line.substring(openParenIndex + 1, closeParenIndex), PARAMETER_SEPARATOR);
                    String changedName = line.substring(line.lastIndexOf(9) + 1);
                    classData.add(changedName, this.createSignature(modifierNames, returnType, originalName, parameterTypes));
                }
            }
        }
        ChangelogImpl changelogImpl = new ChangelogImpl(classes);
        if (changelogImpl == null) {
            ChangelogReader.$$$reportNull$$$0(2);
        }
        return changelogImpl;
    }

    private Signature createSignature(@NotNull String[] modifiers, @NotNull String returnType, @NotNull String name, @NotNull String[] parameterTypes) {
        if (modifiers == null) {
            ChangelogReader.$$$reportNull$$$0(3);
        }
        if (returnType == null) {
            ChangelogReader.$$$reportNull$$$0(4);
        }
        if (name == null) {
            ChangelogReader.$$$reportNull$$$0(5);
        }
        if (parameterTypes == null) {
            ChangelogReader.$$$reportNull$$$0(6);
        }
        Set<Modifier> modifiersSet = Arrays.stream(modifiers).map(Modifier::parse).collect(Collectors.toSet());
        List<Type> parameterTypesList = Arrays.stream(parameterTypes).map(this.myTypes::create).collect(Collectors.toList());
        return new Signature(modifiersSet, this.myTypes.create(returnType), name, parameterTypesList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/ChangelogReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/ChangelogReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum State {
        INITIAL,
        CLASS,
        SOURCE,
        METHODS;

    }
}

