/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.zkm.bytecode.ClassProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectClasses
implements ClassProvider {
    private final Project myProject;

    ProjectClasses(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean contains(@NotNull String className) {
        if (className == null) {
            ProjectClasses.$$$reportNull$$$0(0);
        }
        return this.findClassFile(className) != null;
    }

    @Nullable
    private VirtualFile findClassFile(@NotNull String className) {
        VirtualFile productionPath;
        PsiClass psiClass;
        if (className == null) {
            ProjectClasses.$$$reportNull$$$0(1);
        }
        if ((psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)className)) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
        if (moduleExtension == null) {
            return null;
        }
        String relativeClassPath = className.replace('.', '/') + ".class";
        VirtualFile productionOutputBase = moduleExtension.getCompilerOutputPath();
        VirtualFile virtualFile = productionPath = productionOutputBase != null ? productionOutputBase.findFileByRelativePath(relativeClassPath) : null;
        if (productionPath != null) {
            return productionPath;
        }
        VirtualFile testOutputBase = moduleExtension.getCompilerOutputPathForTests();
        return testOutputBase != null ? testOutputBase.findFileByRelativePath(relativeClassPath) : null;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String className) throws IOException {
        VirtualFile classFile;
        if (className == null) {
            ProjectClasses.$$$reportNull$$$0(2);
        }
        if ((classFile = this.findClassFile(className)) == null) {
            throw new NoSuchElementException(className);
        }
        InputStream inputStream = classFile.getInputStream();
        if (inputStream == null) {
            ProjectClasses.$$$reportNull$$$0(3);
        }
        return inputStream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/ProjectClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/ProjectClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findClassFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

