/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.zkm.bytecode.BytecodeImpl;
import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ChangelogReader;
import com.intellij.zkm.bytecode.ClassProvider;
import com.intellij.zkm.bytecode.InvocationReaderImpl;
import com.intellij.zkm.bytecode.JarArchive;
import com.intellij.zkm.bytecode.ProjectClasses;
import com.intellij.zkm.bytecode.SignatureReaderImpl;
import com.intellij.zkm.bytecode.TranslationException;
import com.intellij.zkm.bytecode.TranslatorImpl;
import com.intellij.zkm.bytecode.TypeFactoryImpl;
import com.intellij.zkm.bytecode.UnscramblingSettings;
import com.intellij.zkm.bytecode.ZKMBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZKMBytecodeUnscrambleSupport
implements UnscrambleSupport<UnscramblingSettings> {
    @NotNull
    public String getPresentableName() {
        String string = ZKMBundle.message("zkm.scrambler.presentable.name", new Object[0]);
        if (string == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public UnscramblingSettings createSettingsComponent() {
        return new UnscramblingSettings();
    }

    @Nullable
    public String unscramble(@NotNull Project project, @NotNull String text, @NotNull String logName, UnscramblingSettings settings) {
        if (project == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(1);
        }
        if (text == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(2);
        }
        if (logName == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(3);
        }
        String bytecodeFilePath = settings.getSelectedJarFilePath();
        try {
            TranslatorImpl translator = ZKMBytecodeUnscrambleSupport.createTranslator(new File(logName), bytecodeFilePath == null ? null : new File(bytecodeFilePath), project);
            return translator.translate(text);
        }
        catch (TranslationException | IOException e) {
            Messages.showMessageDialog((Project)project, (String)(e.getMessage() + "\n" + e.toString()), (String)ZKMBundle.message("zkm.error.unscrambling.stacktrace", new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    @NotNull
    private static TranslatorImpl createTranslator(@NotNull File logFile, @Nullable File bytecodeFile, @NotNull Project project) throws IOException {
        Changelog changelog;
        if (logFile == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(5);
        }
        TypeFactoryImpl typeFactory = new TypeFactoryImpl();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            changelog = new ChangelogReader(typeFactory).read(reader);
        }
        ClassProvider classProvider = bytecodeFile == null ? new ProjectClasses(project) : new JarArchive(bytecodeFile);
        BytecodeImpl bytecode = new BytecodeImpl(classProvider, new SignatureReaderImpl(typeFactory), new InvocationReaderImpl(typeFactory));
        TranslatorImpl translatorImpl = new TranslatorImpl(changelog, bytecode);
        if (translatorImpl == null) {
            ZKMBytecodeUnscrambleSupport.$$$reportNull$$$0(6);
        }
        return translatorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unscramble";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTranslator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

