/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.facet.FacetManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamFactory;
import com.intellij.seam.model.jam.SeamJamInstall;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModel;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.MultiValuedProperty;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.model.xml.components.SeamDomFactory;
import com.intellij.seam.model.xml.components.SeamImport;
import com.intellij.seam.model.xml.components.SeamValue;
import com.intellij.seam.model.xml.core.BasicBundleNamesHolder;
import com.intellij.seam.utils.beans.ContextVariable;
import com.intellij.seam.utils.beans.DomFactoryContextVariable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamCommonUtils {
    private static final String EL_START = "#{";
    private static final String EL_END = "}";
    private static final Key<CachedValue<Set<SeamFacet>>> MODULE_SEAM_FACETS = Key.create((String)"MODULE_SEAM_FACETS");

    private SeamCommonUtils() {
    }

    public static Set<ContextVariable> getSeamContextVariablesWithDependencies(Module module) {
        return SeamCommonUtils.getSeamContextVariablesWithDependencies(module, true, true);
    }

    public static Set<ContextVariable> getSeamContextVariables(@Nullable Module module, boolean jam, boolean dom) {
        return SeamCommonUtils.getSeamContextVariables(module, jam, dom, true);
    }

    public static Set<ContextVariable> getSeamContextVariablesWithDependencies(@Nullable Module module, boolean jam, boolean dom) {
        if (module == null) {
            return Collections.emptySet();
        }
        Set<ContextVariable> contextVariables = SeamCommonUtils.getSeamContextVariables(module, jam, dom, true);
        for (Module mod : JamCommonUtil.getAllModuleDependencies((Module)module)) {
            contextVariables.addAll(SeamCommonUtils.getSeamContextVariables(mod, jam, dom, false));
        }
        return contextVariables;
    }

    public static Set<ContextVariable> getSeamContextVariables(@Nullable Module module, boolean jam, boolean dom, boolean fromLibs) {
        HashSet<ContextVariable> vars = new HashSet<ContextVariable>();
        if (module != null) {
            Set<String> globalImports = SeamCommonUtils.getGlobalImports(module);
            if (jam) {
                SeamCommonUtils.addAnnotatedContextVariables(module, vars, fromLibs);
            }
            if (dom) {
                SeamCommonUtils.addXmlDefinedContextVariables(module, vars);
                SeamCommonUtils.addXmlDefinedFactoryContextVariables(module, globalImports, vars);
                SeamCommonUtils.addMergedContextVariables(module, vars, fromLibs);
            }
            HashSet<ContextVariable> notImported = new HashSet<ContextVariable>(vars);
            for (ContextVariable contextVariable : notImported) {
                SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createImportedVariables(contextVariable, notImported, globalImports), vars);
            }
        }
        return vars;
    }

    private static void addMergedContextVariables(Module module, Set<ContextVariable> vars, boolean fromLibs) {
        List<SeamJamComponent> mergedComponents = SeamJamModel.getModel(module).getAnnotatedSeamComponents(fromLibs);
        for (SeamJamComponent mergedComponent : mergedComponents) {
            if (!mergedComponent.isValid()) continue;
            SeamCommonUtils.addImplicitContextVariables(module, vars, mergedComponent);
        }
    }

    public static List<String> getSeamContextVariableNames(Module module) {
        return ContainerUtil.map2List(SeamCommonUtils.getSeamContextVariablesWithDependencies(module), contextVariable -> contextVariable.getName());
    }

    public static void addAnnotatedContextVariables(Module module, Set<ContextVariable> vars, boolean fromLibs) {
        Set<SeamJamComponent> seamComponents = SeamJamModel.getModel(module).getSeamComponents(false, fromLibs);
        HashSet<ContextVariable> annotatedVariables = new HashSet<ContextVariable>();
        for (SeamJamComponent seamComponent : seamComponents) {
            if (!seamComponent.isValid()) continue;
            SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(seamComponent, seamComponent.getComponentName(), seamComponent.getComponentType()), annotatedVariables);
            SeamCommonUtils.addImplicitContextVariables(module, annotatedVariables, seamComponent);
        }
        for (SeamJamComponent seamComponent : seamComponents) {
            for (SeamJamOutjection outjection : seamComponent.getOutjections()) {
                String name = outjection.getName();
                PsiType type = outjection.getType();
                if (StringUtil.isEmptyOrSpaces((String)name) || type == null || SeamCommonUtils.isAlreadyDefined(name, type, annotatedVariables)) continue;
                SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(outjection, name, type), annotatedVariables);
            }
        }
        vars.addAll(annotatedVariables);
    }

    private static void addImplicitContextVariables(Module module, Set<ContextVariable> annotatedVariables, SeamJamComponent jamComponent) {
        for (SeamJamRole seamJamRole : jamComponent.getRoles()) {
            SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(seamJamRole, seamJamRole.getName(), seamJamRole.getComponentType()), annotatedVariables);
        }
        for (SeamJamFactory seamJamFactory : jamComponent.getFactories()) {
            SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(seamJamFactory, seamJamFactory.getFactoryName(), seamJamFactory.getFactoryType()), annotatedVariables);
        }
        for (SeamJamDataModel seamJamDataModel : jamComponent.getDataModels()) {
            SeamCommonUtils.addDataModels(module, annotatedVariables, seamJamDataModel);
        }
    }

    private static void addDataModels(Module module, Set<ContextVariable> annotatedVariables, SeamJamDataModel dataModel) {
        PsiType type = dataModel.getType();
        if (type != null) {
            SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(dataModel, dataModel.getName(), type), annotatedVariables);
        } else {
            PsiClass dataModelClazz = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.faces.model.DataModel", GlobalSearchScope.allScope((Project)module.getProject()));
            if (dataModelClazz != null) {
                PsiClassType classType = JavaPsiFacade.getInstance((Project)module.getProject()).getElementFactory().createType(dataModelClazz);
                SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(dataModel, dataModel.getName(), (PsiType)classType), annotatedVariables);
            }
        }
    }

    public static Set<String> getGlobalImports(Module module) {
        HashSet<String> imports = new HashSet<String>();
        List<SeamDomModel> models = SeamDomModelManager.getInstance(module.getProject()).getAllModels(module);
        for (SeamDomModel model : models) {
            for (SeamImport seamImport : model.getImports()) {
                String stringValue = seamImport.getStringValue();
                if (stringValue == null) continue;
                imports.add(stringValue);
            }
        }
        return imports;
    }

    public static void addXmlDefinedContextVariables(Module module, Set<ContextVariable> vars) {
        Project project = module.getProject();
        List<SeamDomModel> models = SeamDomModelManager.getInstance(project).getAllModels(module);
        for (SeamDomModel model : models) {
            for (SeamDomComponent seamDomComponent : model.getSeamComponents()) {
                String name = seamDomComponent.getComponentName();
                PsiType type = seamDomComponent.getComponentType();
                if (StringUtil.isEmptyOrSpaces((String)name) || type == null || SeamCommonUtils.isAlreadyDefined(name, type, vars)) continue;
                SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(seamDomComponent, name, type), vars);
            }
            SeamCommonUtils.addBundleContextVariables(vars, project, model);
        }
    }

    private static boolean isAlreadyDefined(@NotNull String name, Set<ContextVariable> vars) {
        if (name == null) {
            SeamCommonUtils.$$$reportNull$$$0(0);
        }
        for (ContextVariable var : vars) {
            if (!var.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyDefined(@NotNull String name, @NotNull PsiType type, Set<ContextVariable> vars) {
        if (name == null) {
            SeamCommonUtils.$$$reportNull$$$0(1);
        }
        if (type == null) {
            SeamCommonUtils.$$$reportNull$$$0(2);
        }
        for (ContextVariable var : vars) {
            if (!var.getName().equals(name) || !var.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static void addXmlDefinedFactoryContextVariables(Module module, Set<String> globalImports, Set<ContextVariable> vars) {
        Project project = module.getProject();
        List<SeamDomModel> models = SeamDomModelManager.getInstance(project).getAllModels(module);
        for (SeamDomModel model : models) {
            for (SeamDomFactory factory : model.getFactories()) {
                SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createSeamDomFactoryContextVariable(factory, vars, module), vars);
            }
        }
    }

    @Nullable
    private static ContextVariable createSeamDomFactoryContextVariable(SeamDomFactory factory, Set<ContextVariable> vars, Module module) {
        String factoryName = factory.getFactoryName();
        if (StringUtil.isEmptyOrSpaces((String)factoryName)) {
            return null;
        }
        return new DomFactoryContextVariable(factory, factoryName, vars, module);
    }

    @Nullable
    public static String getFactoryAliasedVarName(SeamDomFactory factory) {
        String value = factory.getValue().getStringValue();
        if (value != null && SeamCommonUtils.isElText(value)) {
            return value.substring(value.indexOf(EL_START) + EL_START.length(), value.indexOf(EL_END)).trim();
        }
        return null;
    }

    @Nullable
    public static PsiType getFactoryType(SeamDomFactory factory, Module module) {
        return SeamCommonUtils.getFactoryType(factory, SeamCommonUtils.getSeamContextVariablesWithDependencies(module));
    }

    @Nullable
    public static PsiType getFactoryType(SeamDomFactory factory, Set<ContextVariable> vars) {
        String value = factory.getValue().getStringValue();
        if (value != null && SeamCommonUtils.isElText(value)) {
            String aliasedVar = value.substring(value.indexOf(EL_START) + EL_START.length(), value.indexOf(EL_END));
            for (ContextVariable var : vars) {
                if (var instanceof DomFactoryContextVariable || !var.getName().equals(aliasedVar)) continue;
                return var.getType();
            }
        }
        return null;
    }

    public static PsiType getObjectClassType(Project project) {
        PsiType psiType = SeamCommonUtils.getPsiClassTypeByName(project, "java.lang.Object");
        return psiType == null ? PsiType.VOID : psiType;
    }

    @Nullable
    private static PsiType getPsiClassTypeByName(Project project, String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass == null ? null : psiFacade.getElementFactory().createType(psiClass);
    }

    public static boolean isElText(@NotNull String s) {
        if (s == null) {
            SeamCommonUtils.$$$reportNull$$$0(3);
        }
        int startIndex = s.indexOf(EL_START);
        int endIndex = s.indexOf(EL_END);
        return startIndex != -1 && startIndex < endIndex;
    }

    private static void addBundleContextVariables(Set<ContextVariable> vars, Project project, SeamDomModel model) {
        for (DomFileElement fileElement : model.getRoots()) {
            if (!fileElement.isValid()) continue;
            for (BasicBundleNamesHolder bundleNamesHolder : DomUtil.getDefinedChildrenOfType((DomElement)fileElement.getRootElement(), BasicBundleNamesHolder.class)) {
                SeamCommonUtils.addBundleContextVariable(bundleNamesHolder, bundleNamesHolder.getBundleNames(), project, vars);
                for (MultiValuedProperty multiValuedProperty : bundleNamesHolder.getBundleNameses()) {
                    for (SeamValue value : multiValuedProperty.getValues()) {
                        SeamCommonUtils.addBundleContextVariable(bundleNamesHolder, value, project, vars);
                    }
                }
            }
        }
    }

    private static void addBundleContextVariable(CommonModelElement modelElement, SeamValue bundle, Project project, Set<ContextVariable> vars) {
        String bundleName = bundle.getStringValue();
        if (bundleName != null) {
            PsiClassType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName("java.util.PropertyResourceBundle", GlobalSearchScope.allScope((Project)project));
            SeamCommonUtils.addNotNullContextVariable(SeamCommonUtils.createContextVariable(modelElement, bundleName, (PsiType)type), vars);
        }
    }

    @Nullable
    private static ContextVariable createContextVariable(CommonModelElement modelElement, String name, PsiType type) {
        if (name == null || name.length() == 0 || type == null) {
            return null;
        }
        return new ContextVariable(modelElement, name, type);
    }

    private static void addNotNullContextVariable(@Nullable ContextVariable contextVariable, @NotNull Set<ContextVariable> vars) {
        if (vars == null) {
            SeamCommonUtils.$$$reportNull$$$0(4);
        }
        if (contextVariable != null) {
            vars.add(contextVariable);
        }
    }

    @Nullable
    private static ContextVariable createImportedVariables(ContextVariable var, Set<ContextVariable> vars, Set<String> globalImports) {
        String name = var.getName();
        for (String globalImport : globalImports) {
            String varName = SeamCommonUtils.getShortName(name, globalImport);
            if (StringUtil.isEmptyOrSpaces((String)varName) || SeamCommonUtils.isAlreadyDefined(varName, vars)) continue;
            return SeamCommonUtils.createContextVariable(var.getModelElement(), varName, var.getType());
        }
        return null;
    }

    @Nullable
    private static String getShortName(String name, String globalImport) {
        if (name.startsWith(globalImport) && name.length() > globalImport.length() && name.charAt(globalImport.length()) == '.') {
            return name.substring(globalImport.length() + 1);
        }
        return null;
    }

    public static Set<SeamFacet> getAllSeamFacets(Project project) {
        HashSet<SeamFacet> result = new HashSet<SeamFacet>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            result.addAll(SeamCommonUtils.getAllSeamFacets(module));
        }
        return result;
    }

    @NotNull
    public static Set<SeamFacet> getAllSeamFacetsWithDependencies(Module module) {
        CachedValue cachedValue = (CachedValue)module.getUserData(MODULE_SEAM_FACETS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                HashSet<? extends SeamFacet> facets = new HashSet<SeamFacet>();
                for (Module depModule : JamCommonUtil.getAllDependentModules((Module)module)) {
                    facets.addAll(SeamCommonUtils.getAllSeamFacets(depModule));
                }
                return new CachedValueProvider.Result(facets, new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
            }, false);
            module.putUserData(MODULE_SEAM_FACETS, (Object)cachedValue);
        }
        Set set = (Set)cachedValue.getValue();
        if (set == null) {
            SeamCommonUtils.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static Collection<? extends SeamFacet> getAllSeamFacets(Module module) {
        return FacetManager.getInstance((Module)module).getFacetsByType(SeamFacet.FACET_TYPE_ID);
    }

    @NotNull
    public static Set<Module> getDependentFacetModules(SeamFacet facet) {
        HashSet<Module> modules = new HashSet<Module>();
        Module module = facet.getModule();
        for (Module depModule : JamCommonUtil.getAllDependentModules((Module)module)) {
            if (SeamCommonUtils.isModuleContainsSeamFacet(depModule)) continue;
            modules.add(depModule);
        }
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            SeamCommonUtils.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    public static boolean isSeamFacetDefined(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        if (SeamCommonUtils.isModuleContainsSeamFacet(module)) {
            return true;
        }
        for (Module depModule : JamCommonUtil.getAllModuleDependencies((Module)module)) {
            if (!SeamCommonUtils.isModuleContainsSeamFacet(depModule)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModuleContainsSeamFacet(Module module) {
        return SeamFacet.getInstance(module) != null;
    }

    @NotNull
    public static List<CommonModelElement> findSeamComponents(String name, Module module) {
        ArrayList<CommonModelElement> components = new ArrayList<CommonModelElement>();
        for (ContextVariable variable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module)) {
            if (!name.equals(variable.getName())) continue;
            components.add(variable.getModelElement());
        }
        ArrayList<CommonModelElement> arrayList = components;
        if (arrayList == null) {
            SeamCommonUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static EjbClassRole[] getEjbRoles(SeamJamComponent seamComponent) {
        return EjbHelper.getEjbHelper().getEjbRoles(seamComponent.getPsiElement());
    }

    public static boolean isStateful(SessionBean sessionBean) {
        return sessionBean.getSessionType().getValue() == SessionType.STATEFUL;
    }

    public static boolean isSeamClass(PsiClass psiClass) {
        return SeamCommonUtils.isSeamComponent(psiClass);
    }

    @Nullable
    public static PsiType getUnwrapType(PsiClass psiClass) {
        for (PsiMethod method : psiClass.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.jboss.seam.annotations.Unwrap", (boolean)false)) continue;
            return method.getReturnType();
        }
        return null;
    }

    @Nullable
    public static ContextVariable getContextVariable(String variableName, Module module) {
        for (ContextVariable variable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module)) {
            if (!variableName.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public static boolean isSeamComponent(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SeamCommonUtils.$$$reportNull$$$0(8);
        }
        return SeamCommonUtils.getSeamJamComponent(aClass) != null;
    }

    @Nullable
    public static SeamJamComponent getSeamJamComponent(PsiClass aClass) {
        return (SeamJamComponent)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SeamJamComponent.META});
    }

    public static boolean isAbstractSeamComponent(PsiClass aClass) {
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        boolean isAbstarct = modifierList.hasModifierProperty("abstract");
        if (isAbstarct) {
            for (PsiClass inheritorClass : ClassInheritorsSearch.search((PsiClass)aClass).findAll()) {
                if (!SeamCommonUtils.isSeamComponent(inheritorClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static SeamJamComponent getPair(SeamDomComponent domComponent) {
        String componentName;
        SeamJamComponent seamComponent;
        PsiClass psiClass;
        PsiType type = domComponent.getComponentType();
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && (seamComponent = SeamCommonUtils.getSeamJamComponent(psiClass)) != null && (componentName = seamComponent.getComponentName()) != null && componentName.equals(domComponent.getComponentName())) {
            return seamComponent;
        }
        return null;
    }

    public static boolean comparelInstalls(SeamJamComponent seamComponent, SeamJamComponent checkedComponent) {
        return SeamCommonUtils.getPrecedence(seamComponent) == SeamCommonUtils.getPrecedence(checkedComponent);
    }

    public static boolean comparelInstalls(SeamJamComponent seamComponent, SeamDomComponent checkedComponent) {
        return SeamCommonUtils.getPrecedence(seamComponent) == SeamCommonUtils.getPrecedence(checkedComponent);
    }

    private static int getPrecedence(SeamJamComponent seamComponent) {
        SeamJamInstall install = seamComponent.getInstall();
        return install == null ? 20 : install.getPrecedence();
    }

    private static int getPrecedence(SeamDomComponent seamComponent) {
        Integer install = (Integer)seamComponent.getPrecedence().getValue();
        return install == null ? 20 : install;
    }

    public static FileTemplate chooseTemplate(Module module) {
        String version = JarVersionDetectionUtil.detectJarVersion((String)"org.jboss.seam.annotations.Name", (Module)module);
        String templateName = version != null && version.startsWith("1") ? "components.1_2.xml" : "components.2_0.xml";
        return FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(templateName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/utils/SeamCommonUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/utils/SeamCommonUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSeamFacetsWithDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentFacetModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findSeamComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyDefined";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isElText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNotNullContextVariable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSeamComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

