/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssVersionDescriptorComparator;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDescriptorsUtil {
    public static final NotNullFunction<CssElementDescriptor, String> GET_DESCRIPTOR_ID_FUNCTION = descriptor -> descriptor.getId();
    private static final Key<ParameterizedCachedValue<CssElementDescriptorProvider, PsiElement>> DESCRIPTOR_PROVIDER_KEY = Key.create((String)"css.descriptor.provider");
    private static final ParameterizedCachedValueProvider<CssElementDescriptorProvider, PsiElement> DESCRIPTOR_PROVIDER_CACHE_VALUE = new ParameterizedCachedValueProvider<CssElementDescriptorProvider, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<CssElementDescriptorProvider> compute(PsiElement param) {
            return CachedValueProvider.Result.create((Object)CssDescriptorsUtil.innerFindDescriptorProvider(param), (Object[])new Object[]{param});
        }
    };

    private CssDescriptorsUtil() {
    }

    @Nullable
    public static CssElementDescriptorProvider findDescriptorProvider(@Nullable PsiElement context) {
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssStylesheet.class});
        if (stylesheet != null) {
            return (CssElementDescriptorProvider)CachedValuesManager.getManager((Project)stylesheet.getProject()).getParameterizedCachedValue((UserDataHolder)stylesheet, DESCRIPTOR_PROVIDER_KEY, DESCRIPTOR_PROVIDER_CACHE_VALUE, false, (Object)context);
        }
        return CssDescriptorsUtil.innerFindDescriptorProvider(context);
    }

    private static CssElementDescriptorProvider innerFindDescriptorProvider(PsiElement context) {
        CssElementDescriptorProvider[] providers;
        LinkedList<CssElementDescriptorProvider> applicableProviders = new LinkedList<CssElementDescriptorProvider>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            if (!provider.isMyContext(context)) continue;
            applicableProviders.add(provider);
            if (!provider.shouldAskOtherProviders(context)) break;
        }
        if (applicableProviders.size() == 1) {
            return (CssElementDescriptorProvider)ContainerUtil.getFirstItem(applicableProviders);
        }
        return !applicableProviders.isEmpty() ? new CompositeCssElementDescriptorProvider(applicableProviders) : null;
    }

    @NotNull
    public static String[] getSimpleSelectors(@NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(0);
        }
        String[] stringArray = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getSimpleSelectors(context) : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(2);
        }
        return CssDescriptorsUtil.getPropertyDescriptor(declaration.getPropertyName(), declaration);
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPropertyDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getPseudoSelectorDescriptors(@NotNull String pseudoSelectorName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (pseudoSelectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(4);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findPseudoSelectorDescriptors(pseudoSelectorName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssFunctionDescriptor> getFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (functionName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(6);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findFunctionDescriptors(functionName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(8);
        }
        Collection<? extends CssPropertyDescriptor> collection = CssDescriptorsUtil.getPropertyDescriptors(declaration.getPropertyName(), declaration);
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(10);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getMediaFeatureDescriptors(@NotNull String featureName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (featureName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(12);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.findMediaFeatureDescriptors(featureName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllMediaFeatureDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(15);
        }
        return (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getPropertyDescriptor(propertyName, context) : null;
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (selector == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(17);
        }
        return (provider = CssDescriptorsUtil.findDescriptorProvider(context)) == null || provider.isPossibleSelector(selector, context);
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (selectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(19);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(21);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(22);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtil.findDescriptorProvider(context);
        Collection<Object> collection = provider != null ? provider.getAllPseudoSelectorDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @NotNull
    public static String getCanonicalPropertyName(@NotNull CssDeclaration declaration) {
        String propertyName;
        CssPropertyDescriptor descriptor;
        if (declaration == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(25);
        }
        String string = (descriptor = CssDescriptorsUtil.getPropertyDescriptor(propertyName = declaration.getPropertyName(), declaration)) != null ? descriptor.toCanonicalName(propertyName) : propertyName;
        if (string == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public static <T extends CssElementDescriptor> T getDescriptorFromLatestSpec(Collection<T> descriptors) {
        CssElementDescriptor result = null;
        for (CssElementDescriptor descriptor : descriptors) {
            if (result != null && descriptor.getCssVersion().value() < result.getCssVersion().value()) continue;
            result = descriptor;
        }
        return (T)result;
    }

    @NotNull
    public static String[] extractDescriptorsIdsAsArray(Collection<? extends CssElementDescriptor> descriptors) {
        String[] stringArray = (String[])ContainerUtil.map2Array(descriptors, String.class, GET_DESCRIPTOR_ID_FUNCTION);
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    @NotNull
    public static Set<String> extractDescriptorsIds(Collection<? extends CssElementDescriptor> descriptors) {
        Set set = ContainerUtil.map2LinkedSet(descriptors, GET_DESCRIPTOR_ID_FUNCTION);
        if (set == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    public static Set<String> extractDocumentations(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable PsiElement context) {
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(29);
        }
        Set set = ContainerUtil.map2LinkedSet(descriptors, input -> input.getDocumentationString(context));
        if (set == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(30);
        }
        return set;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaType(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        Set<CssMediaType> allowedMediaTypes;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(31);
        }
        if ((allowedMediaTypes = CssPsiUtil.getAllowedMediaTypesInContext(context)).contains((Object)CssMediaType.ALL)) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(32);
            }
            return collection;
        }
        boolean insidePageRule = false;
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
        while (atRule != null) {
            if (atRule.getType() == CssContextType.PAGE || atRule.getType() == CssContextType.PAGE_MARGIN) {
                insidePageRule = true;
                break;
            }
            atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)atRule, CssAtRule.class);
        }
        boolean finalInsidePageRule = insidePageRule;
        List list = ContainerUtil.filter(descriptors, t -> {
            for (CssMediaType mediaType : allowedMediaTypes) {
                CssMediaGroup[] propertyMediaGroups;
                for (CssMediaGroup propertyMediaGroup : propertyMediaGroups = t.getMediaGroups()) {
                    if (propertyMediaGroup != CssMediaGroup.ALL && (!finalInsidePageRule || propertyMediaGroup != CssMediaGroup.PAGED) && !ArrayUtil.contains((Object)((Object)propertyMediaGroup), (Object[])((Object[])mediaType.getSupportedGroups()))) continue;
                    return true;
                }
            }
            return false;
        });
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContext(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        CssContextType ruleType;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(34);
        }
        CssContextType cssContextType = ruleType = (provider = CssDescriptorsUtil.findDescriptorProvider(context)) != null ? provider.getCssContextType(context) : CssContextType.ANY;
        if (ruleType == CssContextType.ANY) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(35);
            }
            return collection;
        }
        List list = ContainerUtil.filter(descriptors, input -> input.isAllowedInContextType(ruleType));
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    public static Collection<CssPseudoSelectorDescriptor> filterPseudoSelectorDescriptorsByColonPrefix(Collection<? extends CssPseudoSelectorDescriptor> descriptors, int prefixLength) {
        return ContainerUtil.filter(descriptors, input -> input.getColonPrefixLength() == prefixLength);
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> sortDescriptors(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(37);
        }
        if (descriptors.size() <= 1) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(38);
            }
            return collection;
        }
        List list = ContainerUtil.sorted(descriptors, (Comparator)new CssVersionDescriptorComparator());
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 2: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pseudoSelectorName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 10: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorName";
                break;
            }
            case 29: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPseudoSelectorDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptors";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaFeatureDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMediaFeatureDescriptors";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPropertyName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDescriptorsIdsAsArray";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDescriptorsIds";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDocumentations";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByMediaType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByContext";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sortDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 2: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPseudoSelectorDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptors";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMediaFeatureDescriptors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPropertyName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractDocumentations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByMediaType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByContext";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sortDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeCssElementDescriptorProvider
    extends CssElementDescriptorProvider {
        private final List<CssElementDescriptorProvider> myProviders;

        public CompositeCssElementDescriptorProvider(List<CssElementDescriptorProvider> providers) {
            this.myProviders = providers;
        }

        @Override
        public boolean isMyContext(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isMyContext(context)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(0);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssPropertyDescriptor descriptor = provider.getPropertyDescriptor(propertyName, context);
                if (descriptor == null) continue;
                return descriptor;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
            if (name == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(1);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findPseudoSelectorDescriptors(name, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
            if (name == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(3);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getNamedValueDescriptors(name, parent));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, PsiElement context) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(5);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findPropertyDescriptors(propertyName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(6);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
            if (functionName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(7);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findFunctionDescriptors(functionName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(8);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
            if (mediaFeatureName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(9);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.findMediaFeatureDescriptors(mediaFeatureName, context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(10);
            }
            return hashSet;
        }

        @Override
        public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
            if (selector == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(11);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(12);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isPossibleSelector(selector, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllPseudoSelectorDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(13);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllPropertyDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(14);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                result.addAll(provider.getAllMediaFeatureDescriptors(context));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(15);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public String[] getSimpleSelectors(@NotNull PsiElement context) {
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(16);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(result, provider.getSimpleSelectors(context));
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)result);
            if (stringArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(17);
            }
            return stringArray;
        }

        @Override
        @NotNull
        public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
            if (selector == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(18);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiElement[] declarations = provider.getDeclarationsForSimpleSelector(selector);
                if (declarations.length == 0) continue;
                if (declarations == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(19);
                }
                return declarations;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(20);
            }
            return PsiElement.EMPTY_ARRAY;
        }

        @Override
        public boolean providesClassicCss() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (provider.providesClassicCss()) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        public PsiElement getDocumentationElementForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(21);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiElement element = provider.getDocumentationElementForSelector(selectorName, context);
                if (element == null) continue;
                return element;
            }
            return null;
        }

        @Override
        @Nullable
        public String generateDocForSelector(@NotNull String selectorName, @Nullable PsiElement context) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(22);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                String doc = provider.generateDocForSelector(selectorName, context);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        @Override
        @Nullable
        public Color getColorByValue(@NotNull String value) {
            if (value == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(23);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Color color = provider.getColorByValue(value);
                if (color == null) continue;
                return color;
            }
            return null;
        }

        @Override
        public boolean isColorTerm(@NotNull CssTerm term) {
            if (term == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(24);
            }
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (!provider.isColorTerm(term)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (propertyName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(25);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(26);
            }
            HashSet quickFixes = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(quickFixes, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(new LocalQuickFix[quickFixes.size()]);
            if (localQuickFixArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(27);
            }
            return localQuickFixArray;
        }

        @Override
        @NotNull
        public LocalQuickFix[] getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
            if (selectorName == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(28);
            }
            if (context == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(29);
            }
            HashSet quickFixes = ContainerUtil.newHashSet();
            for (CssElementDescriptorProvider provider : this.myProviders) {
                Collections.addAll(quickFixes, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
            }
            LocalQuickFix[] localQuickFixArray = quickFixes.toArray(new LocalQuickFix[quickFixes.size()]);
            if (localQuickFixArray == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(30);
            }
            return localQuickFixArray;
        }

        @Override
        public boolean isColorTermsSupported() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                if (provider.isColorTermsSupported()) continue;
                return false;
            }
            return true;
        }

        @Override
        public CssContextType getCssContextType(@Nullable PsiElement context) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssContextType ruleType = provider.getCssContextType(context);
                if (ruleType == CssContextType.ANY) continue;
                return ruleType;
            }
            return CssContextType.ANY;
        }

        @Override
        @NotNull
        public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                PsiReference reference = provider.getStyleReference(element, start, end, caseSensitive);
                if (reference instanceof CssStyleReferenceStub) continue;
                PsiReference psiReference = reference;
                if (psiReference == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(31);
                }
                return psiReference;
            }
            CssStyleReferenceStub cssStyleReferenceStub = new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
            if (cssStyleReferenceStub == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(32);
            }
            return cssStyleReferenceStub;
        }

        @Override
        @NotNull
        public CssValueValidator getValueValidator() {
            for (CssElementDescriptorProvider provider : this.myProviders) {
                CssValueValidator validator = provider.getValueValidator();
                if (validator instanceof CssValueValidatorStub) continue;
                CssValueValidator cssValueValidator = validator;
                if (cssValueValidator == null) {
                    CompositeCssElementDescriptorProvider.$$$reportNull$$$0(33);
                }
                return cssValueValidator;
            }
            CssValueValidator cssValueValidator = super.getValueValidator();
            if (cssValueValidator == null) {
                CompositeCssElementDescriptorProvider.$$$reportNull$$$0(34);
            }
            return cssValueValidator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mediaFeatureName";
                    break;
                }
                case 11: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 12: 
                case 16: 
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 21: 
                case 22: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorName";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "term";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil$CompositeCssElementDescriptorProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPseudoSelectorDescriptors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamedValueDescriptors";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPropertyDescriptors";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFunctionDescriptors";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findMediaFeatureDescriptors";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPseudoSelectorDescriptors";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPropertyDescriptors";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllMediaFeatureDescriptors";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleSelectors";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclarationsForSimpleSelector";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixesForUnknownProperty";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixesForUnknownSimpleSelector";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleReference";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findPseudoSelectorDescriptors";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNamedValueDescriptors";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findPropertyDescriptors";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findFunctionDescriptors";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findMediaFeatureDescriptors";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isPossibleSelector";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getSimpleSelectors";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeclarationsForSimpleSelector";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocumentationElementForSelector";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "generateDocForSelector";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getColorByValue";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isColorTerm";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixesForUnknownProperty";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixesForUnknownSimpleSelector";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

